/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.ArangoDB;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.serde.ArangoSerde;
import java.util.Objects;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBBuilder;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBBuilders;
import org.eclipse.jnosql.databases.arangodb.communication.JsonbSerde;

public abstract class ArangoDBConfiguration {
    protected ArangoDB.Builder builder = new ArangoDB.Builder().serde((ArangoSerde)new JsonbSerde());

    public void addHost(String host, int port) throws NullPointerException {
        Objects.requireNonNull(host, "host is required");
        this.builder.host(host, port);
    }

    public void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) throws NullPointerException {
        Objects.requireNonNull(loadBalancingStrategy, "loadBalancingStrategy is required");
        this.builder.loadBalancingStrategy(loadBalancingStrategy);
    }

    public void setTimeout(int timeout) {
        this.builder.timeout(Integer.valueOf(timeout));
    }

    public void setUser(String user) {
        this.builder.user(user);
    }

    public void setPassword(String password) {
        this.builder.password(password);
    }

    public void setUseSSL(boolean value) {
        this.builder.useSsl(Boolean.valueOf(value));
    }

    public void setSerde(ArangoSerde serde) {
        this.builder.serde(serde);
    }

    protected ArangoDBBuilder getArangoDBBuilder(Settings settings) {
        ArangoDBBuilder aragonDB = new ArangoDBBuilder(this.builder);
        ArangoDBBuilders.load(settings, aragonDB);
        return aragonDB;
    }
}

