/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.Protocol;
import com.arangodb.entity.LoadBalancingStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.Configurations;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBBuilder;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBConfigurations;

final class ArangoDBBuilders {
    private ArangoDBBuilders() {
    }

    static void load(Settings settings, ArangoDBBuilder arangoDB) {
        settings.getSupplier(Arrays.asList(ArangoDBConfigurations.USER, Configurations.USER)).map(Object::toString).ifPresent(arangoDB::user);
        settings.getSupplier(Arrays.asList(ArangoDBConfigurations.PASSWORD, Configurations.PASSWORD)).map(Object::toString).ifPresent(arangoDB::password);
        settings.get((Supplier)ArangoDBConfigurations.TIMEOUT).map(Object::toString).map(Integer::valueOf).ifPresent(arangoDB::timeout);
        settings.get((Supplier)ArangoDBConfigurations.CHUNK_SIZE).map(Object::toString).map(Integer::valueOf).ifPresent(arangoDB::chunkSize);
        settings.get((Supplier)ArangoDBConfigurations.MAX_CONNECTIONS).map(Object::toString).map(Integer::valueOf).ifPresent(arangoDB::maxConnections);
        settings.get((Supplier)ArangoDBConfigurations.USER_SSL).map(Object::toString).map(Boolean::valueOf).ifPresent(arangoDB::useSsl);
        settings.get((Supplier)ArangoDBConfigurations.HOST_LIST).map(Object::toString).map(Boolean::valueOf).ifPresent(arangoDB::acquireHostList);
        settings.get((Supplier)ArangoDBConfigurations.LOAD_BALANCING).map(Object::toString).map(LoadBalancingStrategy::valueOf).ifPresent(arangoDB::loadBalancingStrategy);
        settings.get((Supplier)ArangoDBConfigurations.PROTOCOL).map(Object::toString).map(Protocol::valueOf).ifPresent(arangoDB::protocol);
        settings.prefixSupplier(Arrays.asList(ArangoDBConfigurations.HOST, Configurations.HOST)).stream().map(Object::toString).map(ArangoDBHost::new).flatMap(h -> h.getHost().stream()).forEach(h -> ArangoDBBuilders.host(arangoDB, h));
    }

    private static void host(ArangoDBBuilder arangoDB, String host) {
        String[] values = host.split(":");
        arangoDB.host(values[0], Integer.parseInt(values[1]));
    }

    private record ArangoDBHost(String hots) {
        public List<String> getHost() {
            return Arrays.asList(this.hots.split(","));
        }
    }
}

