/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.communication;

import com.arangodb.ArangoDB;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.jnosql.communication.keyvalue.BucketManagerFactory;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBBucketManager;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBBuilder;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBUtil;

public class ArangoDBBucketManagerFactory
implements BucketManagerFactory {
    private static final String DEFAULT_NAMESPACE = "diana";
    private final ArangoDBBuilder arangoDBBuilder;

    ArangoDBBucketManagerFactory(ArangoDBBuilder arangoDBBuilder) {
        this.arangoDBBuilder = arangoDBBuilder;
    }

    public ArangoDBBucketManager apply(String bucketName) throws UnsupportedOperationException {
        return this.getBucketManager(bucketName, DEFAULT_NAMESPACE);
    }

    public ArangoDBBucketManager getBucketManager(String bucketName, String namespace) {
        ArangoDB arangoDB = this.arangoDBBuilder.build();
        ArangoDBUtil.checkCollection(bucketName, arangoDB, namespace);
        return new ArangoDBBucketManager(arangoDB, bucketName, namespace);
    }

    public Map getMap(String bucketName, Class keyValue, Class valueValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The ArangoDB does not support getMap method");
    }

    public Queue getQueue(String bucketName, Class clazz) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The ArangoDB does not support getQueue method");
    }

    public Set getSet(String bucketName, Class clazz) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The ArangoDB does not support getSet method");
    }

    public List getList(String bucketName, Class clazz) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The ArangoDB does not support getList method");
    }

    public void close() {
    }
}

