/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import java.util.function.Function;
import org.eclipse.jnosql.communication.query.EnumQueryValue;
import org.eclipse.jnosql.communication.query.NumberQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.communication.query.data.DefaultQueryValue;
import org.eclipse.jnosql.communication.query.data.EnumConverter;
import org.eclipse.jnosql.query.grammar.data.JDQLParser;

enum InItemFunction implements Function<JDQLParser.In_itemContext, QueryValue<?>>
{
    INSTANCE;


    @Override
    public QueryValue<?> apply(JDQLParser.In_itemContext item) {
        if (item.literal() != null) {
            JDQLParser.LiteralContext literal = item.literal();
            if (literal.STRING() != null) {
                String text = literal.STRING().getText();
                return StringQueryValue.of(text.substring(1, text.length() - 1));
            }
            if (literal.DOUBLE() != null) {
                return NumberQueryValue.of(Double.valueOf(literal.DOUBLE().getText()));
            }
            if (literal.INTEGER() != null) {
                return NumberQueryValue.of(Integer.valueOf(literal.INTEGER().getText()));
            }
        } else {
            if (item.enum_literal() != null) {
                Enum<?> value = EnumConverter.INSTANCE.apply(item.enum_literal().getText());
                return EnumQueryValue.of(value);
            }
            if (item.input_parameter() != null) {
                return DefaultQueryValue.of(item.input_parameter().getText());
            }
        }
        throw new UnsupportedOperationException("The in item is not supported yet: " + item.getText());
    }
}

