/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.query.ConditionQueryValue;
import org.eclipse.jnosql.communication.query.NullQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.communication.query.Where;
import org.eclipse.jnosql.communication.query.data.AbstractJDQLProvider;
import org.eclipse.jnosql.communication.query.data.DataArrayQueryValue;
import org.eclipse.jnosql.communication.query.data.DefaultQueryCondition;
import org.eclipse.jnosql.communication.query.data.DefaultQueryValue;
import org.eclipse.jnosql.communication.query.data.InItemFunction;
import org.eclipse.jnosql.communication.query.data.PrimaryFunction;
import org.eclipse.jnosql.query.grammar.data.JDQLParser;

abstract class AbstractWhere
extends AbstractJDQLProvider {
    protected Where where;
    protected QueryCondition condition;
    protected boolean and = true;
    protected String entity;

    AbstractWhere() {
    }

    @Override
    protected void runQuery(String query) {
        super.runQuery(query);
        if (Objects.nonNull(this.condition)) {
            this.where = Where.of(this.condition);
        }
    }

    @Override
    public void exitFrom_clause(JDQLParser.From_clauseContext ctx) {
        this.entity = ctx.entity_name().getText();
    }

    @Override
    public void exitComparison_expression(JDQLParser.Comparison_expressionContext ctx) {
        JDQLParser.Conditional_expressionContext ctxParent;
        super.exitComparison_expression(ctx);
        boolean hasNot = false;
        boolean andCondition = true;
        ParserRuleContext parserRuleContext = ctx.getParent();
        if (parserRuleContext instanceof JDQLParser.Conditional_expressionContext && (parserRuleContext = (ctxParent = (JDQLParser.Conditional_expressionContext)parserRuleContext).getParent()) instanceof JDQLParser.Conditional_expressionContext) {
            JDQLParser.Conditional_expressionContext grandParent = (JDQLParser.Conditional_expressionContext)parserRuleContext;
            hasNot = Objects.nonNull(grandParent.NOT());
            andCondition = Objects.isNull(grandParent.OR());
        }
        List<JDQLParser.Scalar_expressionContext> contexts = ctx.scalar_expression();
        Condition contextCondition = this.getCondition(ctx);
        if (contextCondition.equals((Object)Condition.NOT)) {
            contextCondition = Condition.EQUALS;
            hasNot = !hasNot;
        }
        String name = contexts.get(0).getText();
        JDQLParser.Scalar_expressionContext value = contexts.get(1);
        QueryValue<?> literal = PrimaryFunction.INSTANCE.apply(value.primary_expression());
        if (this.condition != null && this.condition.value() instanceof ConditionQueryValue) {
            this.and = andCondition;
        }
        this.checkCondition(new DefaultQueryCondition(name, contextCondition, literal), hasNot);
        this.and = andCondition;
    }

    @Override
    public void exitConditional_expression(JDQLParser.Conditional_expressionContext ctx) {
        super.exitConditional_expression(ctx);
        if (Objects.nonNull(ctx.LPAREN()) || Objects.nonNull(ctx.RPAREN())) {
            throw new UnsupportedOperationException("Eclipse JNoSQL does not support parenthesis is not supported in the query: " + ctx.getText());
        }
    }

    @Override
    public void exitNull_comparison_expression(JDQLParser.Null_comparison_expressionContext ctx) {
        JDQLParser.Conditional_expressionContext ctxParent;
        super.exitNull_comparison_expression(ctx);
        boolean hasNot = Objects.nonNull(ctx.NOT());
        boolean andCondition = true;
        ParserRuleContext parserRuleContext = ctx.getParent();
        if (parserRuleContext instanceof JDQLParser.Conditional_expressionContext && (parserRuleContext = (ctxParent = (JDQLParser.Conditional_expressionContext)parserRuleContext).getParent()) instanceof JDQLParser.Conditional_expressionContext) {
            JDQLParser.Conditional_expressionContext grandParent = (JDQLParser.Conditional_expressionContext)parserRuleContext;
            andCondition = Objects.isNull(grandParent.OR());
        }
        JDQLParser.State_field_path_expressionContext stateFieldPathExpressionContext = ctx.state_field_path_expression();
        String name = stateFieldPathExpressionContext.getText();
        if (this.condition != null && this.condition.value() instanceof ConditionQueryValue) {
            this.and = andCondition;
        }
        this.checkCondition(new DefaultQueryCondition(name, Condition.EQUALS, NullQueryValue.INSTANCE), hasNot);
        this.and = andCondition;
    }

    @Override
    public void exitLike_expression(JDQLParser.Like_expressionContext ctx) {
        JDQLParser.Conditional_expressionContext ctxParent;
        super.exitLike_expression(ctx);
        boolean hasNot = Objects.nonNull(ctx.NOT());
        boolean andCondition = true;
        ParserRuleContext parserRuleContext = ctx.getParent();
        if (parserRuleContext instanceof JDQLParser.Conditional_expressionContext && (parserRuleContext = (ctxParent = (JDQLParser.Conditional_expressionContext)parserRuleContext).getParent()) instanceof JDQLParser.Conditional_expressionContext) {
            JDQLParser.Conditional_expressionContext grandParent = (JDQLParser.Conditional_expressionContext)parserRuleContext;
            andCondition = Objects.isNull(grandParent.OR());
        }
        JDQLParser.Scalar_expressionContext contexts = ctx.scalar_expression();
        String name = contexts.getText();
        Condition contextCondition = Condition.LIKE;
        QueryValue<?> value = AbstractWhere.likeQueryValue(ctx, contexts);
        if (this.condition != null && this.condition.value() instanceof ConditionQueryValue) {
            this.and = andCondition;
        }
        this.checkCondition(new DefaultQueryCondition(name, contextCondition, value), hasNot);
        this.and = andCondition;
    }

    @Override
    public void exitBetween_expression(JDQLParser.Between_expressionContext ctx) {
        JDQLParser.Conditional_expressionContext ctxParent;
        super.exitBetween_expression(ctx);
        boolean hasNot = Objects.nonNull(ctx.NOT());
        boolean andCondition = true;
        ParserRuleContext parserRuleContext = ctx.getParent();
        if (parserRuleContext instanceof JDQLParser.Conditional_expressionContext && (parserRuleContext = (ctxParent = (JDQLParser.Conditional_expressionContext)parserRuleContext).getParent()) instanceof JDQLParser.Conditional_expressionContext) {
            JDQLParser.Conditional_expressionContext grandParent = (JDQLParser.Conditional_expressionContext)parserRuleContext;
            andCondition = Objects.isNull(grandParent.OR());
        }
        List<JDQLParser.Scalar_expressionContext> contexts = ctx.scalar_expression();
        String name = contexts.get(0).getText();
        QueryValue<?> firstValue = PrimaryFunction.INSTANCE.apply(contexts.get(1).primary_expression());
        QueryValue<?> secondValue = PrimaryFunction.INSTANCE.apply(contexts.get(2).primary_expression());
        Condition contextCondition = Condition.BETWEEN;
        if (this.condition != null && this.condition.value() instanceof ConditionQueryValue) {
            this.and = andCondition;
        }
        DataArrayQueryValue value = new DataArrayQueryValue(List.of(firstValue, secondValue));
        this.checkCondition(new DefaultQueryCondition(name, contextCondition, value), hasNot);
        this.and = andCondition;
    }

    @Override
    public void exitIn_expression(JDQLParser.In_expressionContext ctx) {
        JDQLParser.Conditional_expressionContext ctxParent;
        super.exitIn_expression(ctx);
        boolean hasNot = Objects.nonNull(ctx.NOT());
        boolean andCondition = true;
        ParserRuleContext parserRuleContext = ctx.getParent();
        if (parserRuleContext instanceof JDQLParser.Conditional_expressionContext && (parserRuleContext = (ctxParent = (JDQLParser.Conditional_expressionContext)parserRuleContext).getParent()) instanceof JDQLParser.Conditional_expressionContext) {
            JDQLParser.Conditional_expressionContext grandParent = (JDQLParser.Conditional_expressionContext)parserRuleContext;
            andCondition = Objects.isNull(grandParent.OR());
        }
        String name = ctx.state_field_path_expression().getText();
        Condition contextCondition = Condition.IN;
        ArrayList values = new ArrayList();
        for (JDQLParser.In_itemContext item : ctx.in_item()) {
            values.add(InItemFunction.INSTANCE.apply(item));
        }
        if (this.condition != null && this.condition.value() instanceof ConditionQueryValue) {
            this.and = andCondition;
        }
        DataArrayQueryValue value = new DataArrayQueryValue(values);
        this.checkCondition(new DefaultQueryCondition(name, contextCondition, value), hasNot);
        this.and = andCondition;
    }

    @Override
    public void exitFunction_expression(JDQLParser.Function_expressionContext ctx) {
        throw new UnsupportedOperationException("The function is not supported in the query: " + ctx.getText());
    }

    private Condition getCondition(JDQLParser.Comparison_expressionContext ctx) {
        JDQLParser.Comparison_operatorContext context = ctx.comparison_operator();
        if (context.EQ() != null) {
            return Condition.EQUALS;
        }
        if (context.LT() != null) {
            return Condition.LESSER_THAN;
        }
        if (context.LTEQ() != null) {
            return Condition.LESSER_EQUALS_THAN;
        }
        if (context.GT() != null) {
            return Condition.GREATER_THAN;
        }
        if (context.GTEQ() != null) {
            return Condition.GREATER_EQUALS_THAN;
        }
        if (context.NEQ() != null) {
            return Condition.NOT;
        }
        throw new UnsupportedOperationException("The operation does not support: " + ctx.getText());
    }

    private void checkCondition(QueryCondition condition, boolean hasNot) {
        QueryCondition newCondition = this.checkNotCondition(condition, hasNot);
        if (Objects.isNull(this.condition)) {
            this.condition = newCondition;
            return;
        }
        if (this.and) {
            this.appendCondition(Condition.AND, newCondition);
        } else {
            this.appendCondition(Condition.OR, newCondition);
        }
    }

    private void appendCondition(Condition operator, QueryCondition newCondition) {
        if (operator.equals((Object)this.condition.condition())) {
            ConditionQueryValue conditionValue = (ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value());
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditionValue.get());
            conditions.add(newCondition);
            this.condition = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else if (this.isNotAppendable()) {
            List<QueryCondition> conditions = Arrays.asList(this.condition, newCondition);
            this.condition = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else {
            Object conditions = ((ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value())).get();
            QueryCondition lastCondition = (QueryCondition)conditions.get(conditions.size() - 1);
            if (this.isAppendable(lastCondition) && operator.equals((Object)lastCondition.condition())) {
                ArrayList<QueryCondition> lastConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)((ConditionQueryValue)ConditionQueryValue.class.cast(lastCondition.value())).get());
                lastConditions.add(newCondition);
                DefaultQueryCondition newAppendable = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(lastConditions));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>(conditions.subList(0, conditions.size() - 1));
                newConditions.add(newAppendable);
                this.condition = new DefaultQueryCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            } else {
                DefaultQueryCondition newAppendable = new DefaultQueryCondition("_" + operator.name(), operator, ConditionQueryValue.of(Collections.singletonList(newCondition)));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditions);
                newConditions.add(newAppendable);
                this.condition = new DefaultQueryCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            }
        }
    }

    private boolean isAppendable(QueryCondition condition) {
        return Condition.AND.equals((Object)condition.condition()) || Condition.OR.equals((Object)condition.condition());
    }

    private boolean isNotAppendable() {
        return !this.isAppendable(this.condition);
    }

    private QueryCondition checkNotCondition(QueryCondition condition, boolean hasNot) {
        if (hasNot) {
            ConditionQueryValue conditions = ConditionQueryValue.of(Collections.singletonList(condition));
            return new DefaultQueryCondition("_NOT", Condition.NOT, conditions);
        }
        return condition;
    }

    private static QueryValue<?> likeQueryValue(JDQLParser.Like_expressionContext ctx, JDQLParser.Scalar_expressionContext contexts) {
        if (ctx.input_parameter() != null) {
            return DefaultQueryValue.of(ctx.input_parameter().getText());
        }
        int likeValueIndex = ctx.getChildCount() - 1;
        String likeValue = contexts.getParent().getChild(likeValueIndex).getText();
        return StringQueryValue.of(likeValue.substring(1, likeValue.length() - 1));
    }
}

