/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.Where;

public class DeleteQuery
implements Query {
    private final String entity;
    private final List<String> fields;
    private final Where where;

    private DeleteQuery(String entity, List<String> fields, Where where) {
        this.entity = entity;
        this.fields = fields;
        this.where = where;
    }

    public List<String> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    public String entity() {
        return this.entity;
    }

    public Optional<Where> where() {
        return Optional.ofNullable(this.where);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteQuery)) {
            return false;
        }
        DeleteQuery that = (DeleteQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.fields, that.fields) && Objects.equals(this.where, that.where);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.fields, this.where);
    }

    public String toString() {
        return "DeleteQuery{entity='" + this.entity + "', fields=" + this.fields + ", where=" + this.where + "}";
    }

    public static DeleteQuery of(String entity, List<String> fields, Where where) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(fields, "fields is required");
        return new DeleteQuery(entity, fields, where);
    }

    public static DeleteQuery of(String entity, Where where) {
        Objects.requireNonNull(entity, "entity is required");
        return new DeleteQuery(entity, Collections.emptyList(), where);
    }
}

