/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Objects;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;

public final class BooleanQueryValue
implements QueryValue<Boolean> {
    public static final BooleanQueryValue TRUE = new BooleanQueryValue(true);
    public static final BooleanQueryValue FALSE = new BooleanQueryValue(false);
    private final boolean value;

    private BooleanQueryValue(boolean value) {
        this.value = value;
    }

    @Override
    public ValueType type() {
        return ValueType.BOOLEAN;
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanQueryValue that = (BooleanQueryValue)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "BooleanQueryValue{value=" + this.value + "}";
    }
}

