/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class QueryTokenizer
implements Supplier<String> {
    private static final int LIMIT_FIRST = 10;
    private final String value;
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("findBy|deleteBy|countAll|countBy|existsBy|OrderBy|First(?=\\d*By)|First(?=By)|(?<=First\\d{1,})By|(?<=First)By|(?<!First)By|IgnoreCase|And|Or(?!der)|Null|Not|Equals|GreaterThanEqual|True|False|Contains|EndsWith|StartsWith|LessThanEqual|GreaterThan|LessThan|Between|In|Like|Asc|Desc");
    private static final Map<String, String> CACHE = Collections.synchronizedMap(new WeakHashMap());

    private QueryTokenizer(String value) {
        this.value = value;
    }

    @Override
    public String get() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTokenizer that = (QueryTokenizer)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static QueryTokenizer of(String query) {
        Objects.requireNonNull(query, "query is required");
        return new QueryTokenizer(CACHE.computeIfAbsent(query, q -> {
            String tokenized = TOKENIZER_PATTERN.matcher((CharSequence)q).replaceAll(" $0 ").trim().replaceAll("\\s+", " ");
            tokenized = QueryTokenizer.adjustFirstKeywordPosition(tokenized);
            return QueryTokenizer.processOrderBy(tokenized);
        }));
    }

    private static String adjustFirstKeywordPosition(String query) {
        StringBuilder result = new StringBuilder();
        int currentPosition = 0;
        for (String token : query.split(" ")) {
            if (currentPosition >= 10 && token.equals("First")) {
                result.append(token);
            } else {
                result.append(" ").append(token);
            }
            currentPosition += token.length();
        }
        return result.toString().trim();
    }

    private static String processOrderBy(String query) {
        StringBuilder result = new StringBuilder();
        String[] tokens = query.split(" ");
        boolean afterOrderBy = false;
        for (int index = 0; index < tokens.length; ++index) {
            String token = tokens[index];
            if (token.equals("OrderBy")) {
                afterOrderBy = true;
                result.append(token).append(" ");
                continue;
            }
            if (afterOrderBy) {
                if (token.equals("Asc") || token.equals("Desc")) {
                    result.append(token).append(" ");
                } else {
                    while (index < tokens.length && !tokens[index].equals("Asc") && !tokens[index].equals("Desc")) {
                        result.append(tokens[index]);
                        ++index;
                    }
                    if (index < tokens.length) {
                        result.append(" ").append(tokens[index]).append(" ");
                    }
                }
                afterOrderBy = false;
                continue;
            }
            result.append(token).append(" ");
        }
        return result.toString().trim();
    }
}

