/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.UpdateItem;
import org.eclipse.jnosql.communication.query.UpdateQuery;
import org.eclipse.jnosql.communication.query.data.AbstractWhere;
import org.eclipse.jnosql.communication.query.data.JDQLUpdateItem;
import org.eclipse.jnosql.communication.query.data.JDQLUpdateQuery;
import org.eclipse.jnosql.communication.query.data.PrimaryFunction;
import org.eclipse.jnosql.query.grammar.data.JDQLParser;

public final class UpdateProvider
extends AbstractWhere
implements Function<String, UpdateQuery> {
    private final List<UpdateItem> items = new ArrayList<UpdateItem>();

    @Override
    public UpdateQuery apply(String query) {
        Objects.requireNonNull(query, " query is required");
        this.runQuery(query);
        if (this.entity == null) {
            throw new IllegalArgumentException("The entity is required in the query");
        }
        return new JDQLUpdateQuery(this.entity, this.items, this.where);
    }

    @Override
    public void exitUpdate_item(JDQLParser.Update_itemContext ctx) {
        super.exitUpdate_item(ctx);
        String name = ctx.state_field_path_expression().getText();
        JDQLParser.Scalar_expressionContext scalarContext = ctx.scalar_expression();
        if (UpdateProvider.isArithmeticOperation(scalarContext)) {
            throw new UnsupportedOperationException("Eclipse JNoSQL does not support arithmetic operations in the UPDATE clause: " + scalarContext.getText());
        }
        if (this.hasParenthesis(scalarContext)) {
            throw new UnsupportedOperationException("Eclipse JNoSQL does not support parenthesis in the UPDATE clause: " + scalarContext.getText());
        }
        JDQLParser.Primary_expressionContext primaryExpression = scalarContext.primary_expression();
        QueryValue<?> value = PrimaryFunction.INSTANCE.apply(primaryExpression);
        this.items.add(JDQLUpdateItem.of(name, value));
    }

    @Override
    public void exitEntity_name(JDQLParser.Entity_nameContext ctx) {
        super.exitEntity_name(ctx);
        this.entity = ctx.getText();
    }

    @Override
    ParserRuleContext getTree(JDQLParser parser) {
        return parser.update_statement();
    }

    private static boolean isArithmeticOperation(JDQLParser.Scalar_expressionContext scalarContext) {
        return Objects.nonNull(scalarContext.MUL()) || Objects.nonNull(scalarContext.DIV()) || Objects.nonNull(scalarContext.PLUS()) || Objects.nonNull(scalarContext.MINUS()) || Objects.nonNull(scalarContext.CONCAT());
    }

    private boolean hasParenthesis(JDQLParser.Scalar_expressionContext scalarContext) {
        return Objects.nonNull(scalarContext.LPAREN()) || Objects.nonNull(scalarContext.RPAREN());
    }
}

