/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import jakarta.data.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.data.AbstractWhere;
import org.eclipse.jnosql.communication.query.data.JDQLSelectQuery;
import org.eclipse.jnosql.query.grammar.data.JDQLParser;

public final class SelectProvider
extends AbstractWhere
implements BiFunction<String, String, SelectQuery> {
    private final List<Sort<?>> sorts = new ArrayList();
    private final List<String> fields = new ArrayList<String>();
    private boolean count = false;

    @Override
    public SelectQuery apply(String query, String entity) {
        Objects.requireNonNull(query, " query is required");
        this.entity = entity;
        this.runQuery(query);
        if (this.entity == null) {
            throw new IllegalArgumentException("The entity is required in the query");
        }
        return new JDQLSelectQuery(this.fields, this.entity, this.sorts, this.where, this.count);
    }

    @Override
    public void exitAggregate_expression(JDQLParser.Aggregate_expressionContext ctx) {
        super.exitAggregate_expression(ctx);
        this.count = true;
    }

    @Override
    public void exitOrderby_clause(JDQLParser.Orderby_clauseContext ctx) {
        ctx.orderby_item().stream().forEach(o -> {
            String field = o.state_field_path_expression().getText();
            boolean desc = o.getChild(1).getText().equals("DESC");
            this.sorts.add(desc ? Sort.desc((String)field) : Sort.asc((String)field));
        });
    }

    @Override
    public void exitSelect_list(JDQLParser.Select_listContext ctx) {
        List<JDQLParser.State_field_path_expressionContext> stateField = ctx.state_field_path_expression();
        JDQLParser.Aggregate_expressionContext aggregate = ctx.aggregate_expression();
        if (stateField != null) {
            stateField.stream().map(ParseTree::getText).forEach(this.fields::add);
        } else if (aggregate != null) {
            this.count = true;
        }
    }

    @Override
    JDQLParser.Select_statementContext getTree(JDQLParser parser) {
        return parser.select_statement();
    }
}

