/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.BooleanQueryValue;
import org.eclipse.jnosql.communication.query.EnumQueryValue;
import org.eclipse.jnosql.communication.query.NumberQueryValue;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.communication.query.data.DefaultQueryValue;
import org.eclipse.jnosql.communication.query.data.EnumConverter;
import org.eclipse.jnosql.query.grammar.data.JDQLParser;

enum PrimaryFunction implements Function<JDQLParser.Primary_expressionContext, QueryValue<?>>
{
    INSTANCE;

    private static final Logger LOGGER;

    @Override
    public QueryValue<?> apply(JDQLParser.Primary_expressionContext context) {
        if (context.literal() != null) {
            JDQLParser.LiteralContext literal = context.literal();
            if (literal.STRING() != null) {
                String text = literal.STRING().getText();
                return StringQueryValue.of(text.substring(1, text.length() - 1));
            }
            if (literal.INTEGER() != null) {
                return NumberQueryValue.of(Integer.valueOf(literal.INTEGER().getText()));
            }
            if (literal.DOUBLE() != null) {
                return NumberQueryValue.of(Double.valueOf(literal.DOUBLE().getText()));
            }
        } else {
            if (context.input_parameter() != null) {
                return DefaultQueryValue.of(context.input_parameter().getText());
            }
            if (context.special_expression() != null) {
                String specialExpression = context.special_expression().getText();
                return switch (specialExpression.toUpperCase(Locale.US)) {
                    case "TRUE" -> BooleanQueryValue.TRUE;
                    case "FALSE" -> BooleanQueryValue.FALSE;
                    default -> throw new UnsupportedOperationException("The special expression is not supported yet: " + specialExpression);
                };
            }
            if (context.enum_literal() != null) {
                Enum<?> value = EnumConverter.INSTANCE.apply(context.enum_literal().getText());
                return EnumQueryValue.of(value);
            }
            if (context.state_field_path_expression() != null) {
                JDQLParser.State_field_path_expressionContext stateContext = context.state_field_path_expression();
                String stateContextText = stateContext.getText();
                try {
                    Enum<?> value = EnumConverter.INSTANCE.apply(stateContextText);
                    return EnumQueryValue.of(value);
                }
                catch (QueryException exp) {
                    LOGGER.info("Ignoring the enum converter and trying to parse as a class: " + stateContextText);
                }
            }
        }
        throw new UnsupportedOperationException("The primary expression is not supported yet: " + context.getText());
    }

    static {
        LOGGER = Logger.getLogger(PrimaryFunction.class.getName());
    }
}

