/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.jnosql.communication.Condition;
import org.eclipse.jnosql.communication.query.ArrayQueryValue;
import org.eclipse.jnosql.communication.query.BooleanQueryValue;
import org.eclipse.jnosql.communication.query.ConditionQueryValue;
import org.eclipse.jnosql.communication.query.QueryCondition;
import org.eclipse.jnosql.communication.query.QueryErrorListener;
import org.eclipse.jnosql.communication.query.StringQueryValue;
import org.eclipse.jnosql.communication.query.Where;
import org.eclipse.jnosql.communication.query.method.MethodArrayValue;
import org.eclipse.jnosql.communication.query.method.MethodCondition;
import org.eclipse.jnosql.communication.query.method.MethodParamQueryValue;
import org.eclipse.jnosql.query.grammar.method.MethodBaseListener;
import org.eclipse.jnosql.query.grammar.method.MethodLexer;
import org.eclipse.jnosql.query.grammar.method.MethodParser;

abstract class AbstractMethodQueryProvider
extends MethodBaseListener {
    private static final String SUB_ENTITY_FLAG = "_";
    protected Where where;
    protected QueryCondition condition;
    protected boolean and = true;
    protected boolean shouldCount = false;

    AbstractMethodQueryProvider() {
    }

    protected void runQuery(String query) {
        CodePointCharStream stream = CharStreams.fromString((String)query);
        MethodLexer lexer = new MethodLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MethodParser parser = new MethodParser((TokenStream)tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)QueryErrorListener.INSTANCE);
        parser.addErrorListener((ANTLRErrorListener)QueryErrorListener.INSTANCE);
        ParseTree tree = this.getParserTree().apply(parser);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, tree);
        if (Objects.nonNull(this.condition)) {
            this.where = Where.of(this.condition);
        }
    }

    abstract Function<MethodParser, ParseTree> getParserTree();

    @Override
    public void exitSelectStart(MethodParser.SelectStartContext ctx) {
        this.shouldCount = ctx.getText().startsWith("count");
    }

    @Override
    public void exitEq(MethodParser.EqContext ctx) {
        Condition operator = Condition.EQUALS;
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitTruth(MethodParser.TruthContext ctx) {
        String variable = this.getVariable(ctx.variable());
        this.checkCondition(new MethodCondition(variable, Condition.EQUALS, BooleanQueryValue.TRUE), false);
    }

    @Override
    public void exitUntruth(MethodParser.UntruthContext ctx) {
        String variable = this.getVariable(ctx.variable());
        this.checkCondition(new MethodCondition(variable, Condition.EQUALS, BooleanQueryValue.FALSE), false);
    }

    @Override
    public void exitGt(MethodParser.GtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.GREATER_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitGte(MethodParser.GteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.GREATER_EQUALS_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLt(MethodParser.LtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.LESSER_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLte(MethodParser.LteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.LESSER_EQUALS_THAN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitLike(MethodParser.LikeContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.LIKE;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitIn(MethodParser.InContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.IN;
        this.appendCondition(hasNot, variable, operator);
    }

    @Override
    public void exitBetween(MethodParser.BetweenContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        Condition operator = Condition.BETWEEN;
        ArrayQueryValue value = MethodArrayValue.of(variable);
        this.checkCondition(new MethodCondition(variable, operator, value), hasNot);
    }

    @Override
    public void exitNullable(MethodParser.NullableContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String variable = this.getVariable(ctx.variable());
        this.checkCondition(new MethodCondition(variable, Condition.EQUALS, StringQueryValue.of(null)), hasNot);
    }

    @Override
    public void exitAnd(MethodParser.AndContext ctx) {
        this.and = true;
    }

    @Override
    public void exitOr(MethodParser.OrContext ctx) {
        this.and = false;
    }

    @Override
    public void exitContains(MethodParser.ContainsContext ctx) {
        throw new UnsupportedOperationException("Contains is not supported in Eclipse JNoSQL method query");
    }

    @Override
    public void exitEndsWith(MethodParser.EndsWithContext ctx) {
        throw new UnsupportedOperationException("EndsWith is not supported in Eclipse JNoSQL method query");
    }

    @Override
    public void exitStartsWith(MethodParser.StartsWithContext ctx) {
        throw new UnsupportedOperationException("StartsWith is not supported in Eclipse JNoSQL method query");
    }

    @Override
    public void exitIgnoreCase(MethodParser.IgnoreCaseContext ctx) {
        throw new UnsupportedOperationException("IgnoreCase is not supported in Eclipse JNoSQL method query");
    }

    private void appendCondition(boolean hasNot, String variable, Condition operator) {
        MethodParamQueryValue queryValue = new MethodParamQueryValue(variable);
        this.checkCondition(new MethodCondition(variable, operator, queryValue), hasNot);
    }

    private void checkCondition(QueryCondition condition, boolean hasNot) {
        QueryCondition newCondition = this.checkNotCondition(condition, hasNot);
        if (Objects.isNull(this.condition)) {
            this.condition = newCondition;
            return;
        }
        if (this.and) {
            this.appendCondition(Condition.AND, newCondition);
        } else {
            this.appendCondition(Condition.OR, newCondition);
        }
    }

    private String getVariable(MethodParser.VariableContext ctx) {
        return this.getFormatField(ctx.getText());
    }

    protected String getFormatField(String text) {
        if (text.contains(SUB_ENTITY_FLAG)) {
            return Stream.of(text.split(SUB_ENTITY_FLAG)).map(this::formatField).collect(Collectors.joining("."));
        }
        return this.formatField(text);
    }

    private String formatField(String text) {
        String lowerCase = String.valueOf(text.charAt(0)).toLowerCase(Locale.US);
        return lowerCase.concat(text.substring(1));
    }

    private boolean isAppendable(QueryCondition condition) {
        return Condition.AND.equals((Object)condition.condition()) || Condition.OR.equals((Object)condition.condition());
    }

    private boolean isNotAppendable() {
        return !this.isAppendable(this.condition);
    }

    private QueryCondition checkNotCondition(QueryCondition condition, boolean hasNot) {
        if (hasNot) {
            ConditionQueryValue conditions = ConditionQueryValue.of(Collections.singletonList(condition));
            return new MethodCondition("_NOT", Condition.NOT, conditions);
        }
        return condition;
    }

    private void appendCondition(Condition operator, QueryCondition newCondition) {
        if (operator.equals((Object)this.condition.condition())) {
            ConditionQueryValue conditionValue = (ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value());
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditionValue.get());
            conditions.add(newCondition);
            this.condition = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else if (this.isNotAppendable()) {
            List<QueryCondition> conditions = Arrays.asList(this.condition, newCondition);
            this.condition = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, ConditionQueryValue.of(conditions));
        } else {
            Object conditions = ((ConditionQueryValue)ConditionQueryValue.class.cast(this.condition.value())).get();
            QueryCondition lastCondition = (QueryCondition)conditions.get(conditions.size() - 1);
            if (this.isAppendable(lastCondition) && Condition.EQUALS.equals((Object)lastCondition.condition())) {
                ArrayList<QueryCondition> lastConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)((ConditionQueryValue)ConditionQueryValue.class.cast(lastCondition.value())).get());
                lastConditions.add(newCondition);
                MethodCondition newAppendable = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, ConditionQueryValue.of(lastConditions));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>(conditions.subList(0, conditions.size() - 1));
                newConditions.add(newAppendable);
                this.condition = new MethodCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            } else {
                MethodCondition newAppendable = new MethodCondition(SUB_ENTITY_FLAG + operator.name(), operator, ConditionQueryValue.of(Collections.singletonList(newCondition)));
                ArrayList<QueryCondition> newConditions = new ArrayList<QueryCondition>((Collection<QueryCondition>)conditions);
                newConditions.add(newAppendable);
                this.condition = new MethodCondition(this.condition.name(), this.condition.condition(), ConditionQueryValue.of(newConditions));
            }
        }
    }
}

