/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.data;

import java.util.function.Function;
import org.eclipse.jnosql.communication.QueryException;

enum EnumConverter implements Function<String, Enum<?>>
{
    INSTANCE;


    @Override
    public Enum<?> apply(String text) {
        try {
            int lastDotIndex = text.lastIndexOf(46);
            Object enumClassName = text.substring(0, lastDotIndex);
            String enumValueName = text.substring(lastDotIndex + 1);
            try {
                return this.getEnumValue((String)enumClassName, enumValueName);
            }
            catch (ClassNotFoundException e) {
                int secondLastDotIndex = ((String)enumClassName).lastIndexOf(46);
                if (secondLastDotIndex != -1) {
                    enumClassName = ((String)enumClassName).substring(0, secondLastDotIndex) + "$" + ((String)enumClassName).substring(secondLastDotIndex + 1);
                    return this.getEnumValue((String)enumClassName, enumValueName);
                }
                throw e;
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException exp) {
            throw new QueryException("There is an issue to load class because: " + text, (Throwable)exp);
        }
    }

    private Enum<?> getEnumValue(String enumClassName, String enumValueName) throws ClassNotFoundException {
        Class<?> enumClass = Class.forName(enumClassName);
        if (enumClass.isEnum()) {
            Class<Enum> enumType = enumClass.asSubclass(Enum.class);
            return Enum.valueOf(enumType, enumValueName);
        }
        throw new QueryException("There is an issue to load class because it is not an enum: " + enumClassName);
    }
}

