/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import jakarta.data.Direction;
import jakarta.data.Sort;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.query.AbstractWhereSupplier;
import org.eclipse.jnosql.communication.query.DefaultSelectQuery;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class SelectQueryConverter
extends AbstractWhereSupplier
implements Function<String, DefaultSelectQuery> {
    private String entity;
    private List<String> fields = Collections.emptyList();
    private List<Sort<?>> sorts = Collections.emptyList();
    private long skip;
    private long limit;

    @Override
    public void exitFields(QueryParser.FieldsContext ctx) {
        this.fields = ctx.name().stream().map(RuleContext::getText).collect(Collectors.toList());
    }

    @Override
    public void exitSkip(QueryParser.SkipContext ctx) {
        this.skip = Long.parseLong(ctx.INT().getText());
    }

    @Override
    public void exitLimit(QueryParser.LimitContext ctx) {
        this.limit = Long.parseLong(ctx.INT().getText());
    }

    @Override
    public void exitEntity(QueryParser.EntityContext ctx) {
        this.entity = ctx.getText();
    }

    @Override
    public void enterOrder(QueryParser.OrderContext ctx) {
        this.sorts = ctx.orderName().stream().map(this::sort).collect(Collectors.toList());
    }

    @Override
    public DefaultSelectQuery apply(String query) {
        this.runQuery(query);
        return new DefaultSelectQuery(this.entity, this.fields, this.sorts, this.skip, this.limit, this.where);
    }

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::select;
    }

    private Sort<?> sort(QueryParser.OrderNameContext context) {
        String text = context.name().getText();
        Direction type = context.desc() == null ? Direction.ASC : Direction.DESC;
        return Sort.of((String)text, (Direction)type, (boolean)false);
    }
}

