/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.query.DefaultQueryCondition;
import org.eclipse.jnosql.communication.query.InsertQueryConverter;
import org.eclipse.jnosql.communication.query.JSONQueryValue;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.QueryCondition;

public final class InsertQuery
implements Query {
    private final String entity;
    private final Duration duration;
    private final List<DefaultQueryCondition> conditions;
    private final JSONQueryValue value;

    InsertQuery(String entity, Duration duration, List<DefaultQueryCondition> conditions, JSONQueryValue value) {
        this.entity = entity;
        this.duration = duration;
        this.conditions = conditions;
        this.value = value;
    }

    public String entity() {
        return this.entity;
    }

    public Optional<Duration> ttl() {
        return Optional.ofNullable(this.duration);
    }

    public List<QueryCondition> conditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public Optional<JSONQueryValue> value() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsertQuery)) {
            return false;
        }
        InsertQuery that = (InsertQuery)o;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.duration, that.duration) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.duration, this.conditions);
    }

    public String toString() {
        if (this.conditions.isEmpty() && this.value != null) {
            return "insert " + this.entity + " " + this.value + " " + this.ttl().map(Duration::toString).orElse("");
        }
        return "insert " + this.entity + " (" + this.conditions + ") " + this.ttl().map(Duration::toString).orElse("");
    }

    public static InsertQuery parse(String query) {
        Objects.requireNonNull(query, "query is required");
        return new InsertQueryConverter().apply(query);
    }
}

