/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import org.eclipse.jnosql.query.grammar.QueryParser;

final class Durations {
    private Durations() {
    }

    static Duration get(QueryParser.TtlContext ctx) {
        String unit;
        long value = Long.parseLong(ctx.INT().getText());
        return switch (unit = ctx.unit().getText()) {
            case "day" -> Duration.ofDays(value);
            case "hour" -> Duration.ofHours(value);
            case "minute" -> Duration.ofMinutes(value);
            case "second" -> Duration.ofSeconds(value);
            case "millisecond" -> Duration.ofMillis(value);
            case "nanosecond" -> Duration.ofNanos(value);
            default -> throw new UnsupportedOperationException("There isn't support for this unit to TTL: " + unit);
        };
    }
}

