/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class MethodQuery
implements Supplier<String> {
    private final String value;
    private static final Pattern PATTERN = Pattern.compile("findBy|deleteBy|countBy|existsBy|OrderBy|And|Or(?!der)|Not|Equals|GreaterThanEqual|True|False|LessThanEqual|GreaterThan|LessThan|Between|In|Like|Asc|Desc");
    private static final Map<String, String> CACHE = Collections.synchronizedMap(new WeakHashMap());

    private MethodQuery(String value) {
        this.value = value;
    }

    @Override
    public String get() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodQuery that = (MethodQuery)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static MethodQuery of(String query) {
        Objects.requireNonNull(query, "query is required");
        String value = CACHE.get(query);
        if (Objects.isNull(value)) {
            value = PATTERN.matcher(query).replaceAll(" $0 ").trim();
            CACHE.put(query, value);
        }
        return new MethodQuery(value);
    }
}

