/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Objects;
import org.eclipse.jnosql.communication.QueryException;
import org.eclipse.jnosql.communication.query.DefaultFunction;
import org.eclipse.jnosql.communication.query.Elements;
import org.eclipse.jnosql.communication.query.Function;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class FunctionQueryValue
implements QueryValue<Function> {
    private final Function function;

    FunctionQueryValue(Function function) {
        this.function = function;
    }

    @Override
    public Function get() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionQueryValue)) {
            return false;
        }
        FunctionQueryValue that = (FunctionQueryValue)o;
        return Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hashCode(this.function);
    }

    public String toString() {
        return this.function.toString();
    }

    @Override
    public ValueType type() {
        return ValueType.FUNCTION;
    }

    static FunctionQueryValue of(QueryParser.FunctionContext context) {
        if (Objects.nonNull((Object)context.convert())) {
            return FunctionQueryValue.getConverter(context);
        }
        throw new UnsupportedOperationException("There is not support to this function yet");
    }

    private static FunctionQueryValue getConverter(QueryParser.FunctionContext context) {
        QueryParser.ConvertContext converter = context.convert();
        QueryValue<?> value = Elements.getElement(converter.element());
        String text = converter.name().getText();
        try {
            Object[] params = new Object[]{value, Class.forName(text)};
            Function function1 = DefaultFunction.of("convert", params);
            return new FunctionQueryValue(function1);
        }
        catch (ClassNotFoundException e) {
            throw new QueryException("Class does not found the converter function argument: " + text, (Throwable)e);
        }
    }
}

