/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query.method;

import jakarta.data.repository.Direction;
import jakarta.data.repository.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.method.AbstractMethodQueryProvider;
import org.eclipse.jnosql.communication.query.method.MethodQuery;
import org.eclipse.jnosql.communication.query.method.MethodSelectQuery;
import org.eclipse.jnosql.query.grammar.method.MethodParser;

public final class SelectMethodQueryProvider
extends AbstractMethodQueryProvider
implements BiFunction<String, String, SelectQuery> {
    private final List<Sort> sorts = new ArrayList<Sort>();

    @Override
    public SelectQuery apply(String query, String entity) {
        Objects.requireNonNull(query, " query is required");
        Objects.requireNonNull(entity, " entity is required");
        this.runQuery(MethodQuery.of(query).get());
        return new MethodSelectQuery(entity, this.sorts, this.where);
    }

    @Override
    public void exitOrderName(MethodParser.OrderNameContext ctx) {
        this.sorts.add(this.sort(ctx));
    }

    @Override
    Function<MethodParser, ParseTree> getParserTree() {
        return MethodParser::select;
    }

    private Sort sort(MethodParser.OrderNameContext context) {
        String text = context.variable().getText();
        Direction type = context.desc() == null ? Direction.ASC : Direction.DESC;
        return Sort.of((String)this.getFormatField(text), (Direction)type, (boolean)false);
    }
}

