/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.util.Objects;
import org.eclipse.jnosql.communication.query.QueryValue;
import org.eclipse.jnosql.communication.query.ValueType;
import org.eclipse.jnosql.query.grammar.QueryParser;

public final class StringQueryValue
implements QueryValue<String> {
    private final String value;

    StringQueryValue(String value) {
        this.value = value;
    }

    @Override
    public String get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringQueryValue)) {
            return false;
        }
        StringQueryValue that = (StringQueryValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "'" + this.value + "'";
    }

    @Override
    public ValueType type() {
        return ValueType.STRING;
    }

    static StringQueryValue of(QueryParser.StringContext context) {
        String text = context.STRING().getText();
        return new StringQueryValue(text.substring(1, text.length() - 1));
    }
}

