/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import java.util.Optional;
import org.eclipse.jnosql.communication.query.Query;
import org.eclipse.jnosql.communication.query.QueryValue;

public final class PutQuery
implements Query {
    private final QueryValue<?> key;
    private final QueryValue<?> value;
    private final Duration ttl;

    PutQuery(QueryValue<?> key, QueryValue<?> value, Duration ttl) {
        this.key = key;
        this.value = value;
        this.ttl = ttl;
    }

    public QueryValue<?> key() {
        return this.key;
    }

    public QueryValue<?> value() {
        return this.value;
    }

    public Optional<Duration> ttl() {
        return Optional.ofNullable(this.ttl);
    }

    public String toString() {
        StringBuilder put = new StringBuilder();
        put.append("put {").append(this.key).append(" , ").append(this.value);
        if (this.ttl != null) {
            put.append(",").append(this.ttl);
        }
        put.append("}");
        return put.toString();
    }
}

