/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.query;

import java.time.Duration;
import org.eclipse.jnosql.query.grammar.QueryParser;

final class Durations {
    private Durations() {
    }

    static Duration get(QueryParser.TtlContext ctx) {
        String unit;
        long value = Long.parseLong(ctx.INT().getText());
        switch (unit = ctx.unit().getText()) {
            case "day": {
                return Duration.ofDays(value);
            }
            case "hour": {
                return Duration.ofHours(value);
            }
            case "minute": {
                return Duration.ofMinutes(value);
            }
            case "second": {
                return Duration.ofSeconds(value);
            }
            case "millisecond": {
                return Duration.ofMillis(value);
            }
            case "nanosecond": {
                return Duration.ofNanos(value);
            }
        }
        throw new UnsupportedOperationException("There isn't support for this unit to TTL: " + unit);
    }
}

