/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue;

import java.util.Objects;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;

public class KeyValueEntity {
    private final Object key;
    private final Value value;

    KeyValueEntity(Object key, Value value) {
        this.key = key;
        this.value = value;
    }

    public Object key() {
        return this.key;
    }

    public Object value() {
        return this.value.get();
    }

    public <K> K key(TypeSupplier<K> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return (K)Value.of((Object)this.key).get(supplier);
    }

    public <K> K key(Class<K> type) {
        Objects.requireNonNull(type, "type is required");
        return (K)Value.of((Object)this.key).get(type);
    }

    public <V> V value(TypeSupplier<V> supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        return (V)this.value.get(supplier);
    }

    public <V> V value(Class<V> type) {
        Objects.requireNonNull(type, "type is required");
        return (V)this.value.get(type);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueEntity that = (KeyValueEntity)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return "DefaultKeyValueEntity{key=" + this.key + ", value=" + this.value + "}";
    }

    public static <K, V> KeyValueEntity of(K key, V value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        return new KeyValueEntity(KeyValueEntity.getKey(key), KeyValueEntity.getValue(value));
    }

    private static Object getKey(Object key) {
        if (key instanceof Value) {
            return ((Value)Value.class.cast(key)).get();
        }
        return key;
    }

    private static Value getValue(Object value) {
        if (value instanceof Value) {
            return (Value)Value.class.cast(value);
        }
        return Value.of((Object)value);
    }
}

