/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.KeyValueEntity;
import jakarta.nosql.keyvalue.KeyValuePreparedStatement;
import jakarta.nosql.query.PutQuery;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.keyvalue.query.DefaultKeyValuePreparedStatement;
import org.eclipse.jnosql.communication.keyvalue.query.Values;

final class PutQueryParser {
    private final PutQuery.PutQueryProvider provider = PutQuery.getProvider();

    PutQueryParser() {
    }

    Stream<Value> query(String query, BucketManager manager) {
        PutQuery putQuery = (PutQuery)this.provider.apply((Object)query);
        Params params = Params.newParams();
        Value key = Values.getValue(putQuery.getKey(), params);
        Value value = Values.getValue(putQuery.getValue(), params);
        Optional ttl = putQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        KeyValueEntity entity = KeyValueEntity.of((Object)key.get(), (Object)value.get());
        if (ttl.isPresent()) {
            manager.put(entity, (Duration)ttl.get());
        } else {
            manager.put(entity);
        }
        return Stream.empty();
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        PutQuery putQuery = (PutQuery)this.provider.apply((Object)query);
        Params params = Params.newParams();
        Value key = Values.getValue(putQuery.getKey(), params);
        Value value = Values.getValue(putQuery.getValue(), params);
        Optional ttl = putQuery.getTtl();
        return DefaultKeyValuePreparedStatement.put(key, value, manager, params, ttl.orElse(null), query);
    }
}

