/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue.query;

import jakarta.nosql.Params;
import jakarta.nosql.QueryException;
import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.KeyValuePreparedStatement;
import jakarta.nosql.query.DelQuery;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.keyvalue.query.DefaultKeyValuePreparedStatement;
import org.eclipse.jnosql.communication.keyvalue.query.Values;

final class DelQueryParser {
    private final DelQuery.DelQueryProvider provider = DelQuery.getProvider();

    DelQueryParser() {
    }

    Stream<Value> query(String query, BucketManager manager) {
        DelQuery delQuery = (DelQuery)this.provider.apply((Object)query);
        Params params = Params.newParams();
        List values = delQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        List keys = values.stream().map(Value::get).collect(Collectors.toList());
        manager.delete(keys);
        return Stream.empty();
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        DelQuery delQuery = (DelQuery)this.provider.apply((Object)query);
        Params params = Params.newParams();
        List<Value> values = delQuery.getKeys().stream().map(k -> Values.getValue(k, params)).collect(Collectors.toList());
        return DefaultKeyValuePreparedStatement.del(values, manager, params, query);
    }
}

