/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.keyvalue.query;

import jakarta.nosql.QueryException;
import jakarta.nosql.Value;
import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.KeyValuePreparedStatement;
import jakarta.nosql.keyvalue.KeyValueQueryParser;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.keyvalue.query.DelQueryParser;
import org.eclipse.jnosql.communication.keyvalue.query.GetQueryParser;
import org.eclipse.jnosql.communication.keyvalue.query.PutQueryParser;

public class DefaultKeyValueQueryParser
implements KeyValueQueryParser {
    private final PutQueryParser putQueryParser = new PutQueryParser();
    private final GetQueryParser getQueryParser = new GetQueryParser();
    private final DelQueryParser delQueryParser = new DelQueryParser();

    public Stream<Value> query(String query, BucketManager manager) {
        String command;
        this.validation(query, manager);
        switch (command = query.substring(0, 3)) {
            case "get": {
                return this.getQueryParser.query(query, manager);
            }
            case "del": {
                return this.delQueryParser.query(query, manager);
            }
            case "put": {
                return this.putQueryParser.query(query, manager);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    public KeyValuePreparedStatement prepare(String query, BucketManager manager) {
        String command;
        this.validation(query, manager);
        switch (command = query.substring(0, 3)) {
            case "get": {
                return this.getQueryParser.prepare(query, manager);
            }
            case "del": {
                return this.delQueryParser.prepare(query, manager);
            }
            case "put": {
                return this.putQueryParser.prepare(query, manager);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, BucketManager manager) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        if (query.length() <= 4) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

