/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.maven.plugin.mojo.OpenShift;
import org.eclipse.jkube.maven.plugin.mojo.develop.DeployMojo;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.VALIDATE)
@Execute(phase=LifecyclePhase.INSTALL)
public class OpenshiftDeployMojo
extends DeployMojo {
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    private File openshiftManifest;

    public File getManifest(KubernetesClient kubernetesClient) {
        return OpenShift.getOpenShiftManifest(kubernetesClient, this.getKubernetesManifest(), this.openshiftManifest);
    }

    protected String getLogPrefix() {
        return "oc: ";
    }
}

