/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmService;
import org.eclipse.jkube.kit.resource.helm.Maintainer;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class HelmMojo
extends AbstractJKubeMojo {
    private static final String PROPERTY_CHART = "jkube.helm.chart";
    private static final String PROPERTY_CHART_EXTENSION = "jkube.helm.chartExtension";
    private static final String PROPERTY_VERSION = "jkube.helm.version";
    private static final String PROPERTY_DESCRIPTION = "jkube.helm.description";
    private static final String PROPERTY_HOME = "jkube.helm.home";
    private static final String PROPERTY_ICON = "jkube.helm.icon";
    private static final String PROPERTY_TYPE = "jkube.helm.type";
    private static final String PROPERTY_SOURCE_DIR = "jkube.helm.sourceDir";
    private static final String PROPERTY_OUTPUT_DIR = "jkube.helm.outputDir";
    private static final String PROPERTY_TARBALL_OUTPUT_DIR = "jkube.helm.tarballOutputDir";
    private static final String DEFAULT_CHART_EXTENSION = "tar.gz";
    static final String PROPERTY_KUBERNETES_MANIFEST = "jkube.kubernetesManifest";
    static final String PROPERTY_KUBERNETES_TEMPLATE = "jkube.kubernetesTemplate";
    @Parameter
    HelmConfig helm;
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    File kubernetesManifest;
    @Parameter(property="jkube.kubernetesTemplate", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes")
    File kubernetesTemplate;
    @Component
    private MavenProjectHelper projectHelper;

    @Override
    public void executeInternal() throws MojoExecutionException {
        try {
            this.initDefaults();
            HelmService.generateHelmCharts((KitLogger)this.log, (HelmConfig)this.helm);
        }
        catch (IOException exception) {
            throw new MojoExecutionException(exception.getMessage());
        }
    }

    protected File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    protected File getKubernetesTemplate() {
        return this.kubernetesTemplate;
    }

    protected HelmConfig.HelmType getDefaultHelmType() {
        return HelmConfig.HelmType.KUBERNETES;
    }

    private void initDefaults() throws IOException, MojoExecutionException {
        if (this.helm == null) {
            this.helm = new HelmConfig();
        }
        this.initFromPropertyOrDefault(PROPERTY_CHART, () -> ((HelmConfig)this.helm).getChart(), arg_0 -> ((HelmConfig)this.helm).setChart(arg_0), this.project.getArtifactId());
        this.initFromPropertyOrDefault(PROPERTY_CHART_EXTENSION, () -> ((HelmConfig)this.helm).getChartExtension(), arg_0 -> ((HelmConfig)this.helm).setChartExtension(arg_0), DEFAULT_CHART_EXTENSION);
        this.initFromPropertyOrDefault(PROPERTY_VERSION, () -> ((HelmConfig)this.helm).getVersion(), arg_0 -> ((HelmConfig)this.helm).setVersion(arg_0), this.project.getVersion());
        this.initFromPropertyOrDefault(PROPERTY_DESCRIPTION, () -> ((HelmConfig)this.helm).getDescription(), arg_0 -> ((HelmConfig)this.helm).setDescription(arg_0), this.project.getDescription());
        this.initFromPropertyOrDefault(PROPERTY_HOME, () -> ((HelmConfig)this.helm).getHome(), arg_0 -> ((HelmConfig)this.helm).setHome(arg_0), this.project.getUrl());
        if (this.helm.getSources() == null) {
            this.helm.setSources(HelmMojo.sourcesFromProject(this.project));
        }
        if (this.helm.getMaintainers() == null) {
            this.helm.setMaintainers(HelmMojo.maintainersFromProject(this.project));
        }
        this.initFromPropertyOrDefault(PROPERTY_ICON, () -> ((HelmConfig)this.helm).getIcon(), arg_0 -> ((HelmConfig)this.helm).setIcon(arg_0), this.findIconURL());
        this.addAdditionalFiles();
        if (this.helm.getTemplates() == null) {
            this.helm.setTemplates(this.findTemplates());
        }
        this.initHelmTypes();
        this.initFromPropertyOrDefault(PROPERTY_SOURCE_DIR, () -> ((HelmConfig)this.helm).getSourceDir(), arg_0 -> ((HelmConfig)this.helm).setSourceDir(arg_0), String.format("%s/META-INF/jkube/", this.project.getBuild().getOutputDirectory()));
        this.initFromPropertyOrDefault(PROPERTY_OUTPUT_DIR, () -> ((HelmConfig)this.helm).getOutputDir(), arg_0 -> ((HelmConfig)this.helm).setOutputDir(arg_0), String.format("%s/jkube/helm/%s", this.project.getBuild().getDirectory(), this.helm.getChart()));
        this.initFromPropertyOrDefault(PROPERTY_TARBALL_OUTPUT_DIR, () -> ((HelmConfig)this.helm).getTarballOutputDir(), arg_0 -> ((HelmConfig)this.helm).setTarballOutputDir(arg_0), this.project.getBuild().getDirectory());
        this.helm.setGeneratedChartListeners(Collections.singletonList((helmConfig, type, chartFile) -> this.projectHelper.attachArtifact(this.project, this.helm.getChartExtension(), type.getClassifier(), chartFile)));
    }

    private static List<String> sourcesFromProject(MavenProject mavenProject) {
        return Optional.ofNullable(mavenProject).map(MavenProject::getScm).map(Scm::getUrl).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static List<Maintainer> maintainersFromProject(MavenProject mavenProject) {
        return Optional.ofNullable(mavenProject).map(MavenProject::getDevelopers).orElse(Collections.emptyList()).stream().filter(developer -> StringUtils.isNotBlank((CharSequence)developer.getName()) || StringUtils.isNotBlank((CharSequence)developer.getEmail())).map(developer -> new Maintainer(developer.getName(), developer.getEmail())).collect(Collectors.toList());
    }

    private String findIconURL() throws MojoExecutionException {
        String answer = null;
        if (this.getKubernetesManifest() != null && this.getKubernetesManifest().isFile()) {
            KubernetesList list;
            List items;
            KubernetesResource dto;
            try {
                dto = (KubernetesResource)ResourceUtil.load((File)this.getKubernetesManifest(), KubernetesResource.class);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load kubernetes YAML " + this.getKubernetesManifest() + ". " + e, (Exception)e);
            }
            if (dto instanceof HasMetadata) {
                answer = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)((HasMetadata)dto)).get("jkube.io/iconUrl");
            }
            if (StringUtils.isBlank(answer) && dto instanceof KubernetesList && (items = (list = (KubernetesList)dto).getItems()) != null) {
                HasMetadata item;
                Iterator iterator = items.iterator();
                while (iterator.hasNext() && !StringUtils.isNotBlank((CharSequence)(answer = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)(item = (HasMetadata)iterator.next())).get("jkube.io/iconUrl")))) {
                }
            }
        } else {
            this.getLog().warn((CharSequence)("No kubernetes manifest file has been generated yet by the kubernetes:resource goal at: " + this.getKubernetesManifest()));
        }
        return answer;
    }

    private void addAdditionalFiles() {
        if (this.helm.getAdditionalFiles() == null) {
            this.helm.setAdditionalFiles(new ArrayList());
        }
        this.firstProjectFile("README").ifPresent(this.helm.getAdditionalFiles()::add);
        this.firstProjectFile("LICENSE").ifPresent(this.helm.getAdditionalFiles()::add);
    }

    private Optional<File> firstProjectFile(String fileName) {
        FilenameFilter filter = (dir, name) -> {
            String lower = name.toLowerCase(Locale.ENGLISH);
            return lower.equalsIgnoreCase(fileName) || lower.startsWith(fileName.toLowerCase() + ".");
        };
        return Optional.ofNullable(this.project.getBasedir().listFiles(filter)).filter(files -> ((File[])files).length > 0).map(files -> files[0]);
    }

    private List<Template> findTemplates() throws IOException {
        ArrayList<Template> ret = new ArrayList<Template>();
        File[] sourceFiles = this.getKubernetesTemplate() != null && this.getKubernetesTemplate().isDirectory() ? this.getKubernetesTemplate().listFiles((dir, filename) -> filename.endsWith("-template.yml")) : (this.getKubernetesTemplate() != null ? new File[]{this.getKubernetesTemplate()} : new File[]{});
        for (File sourceFile : Objects.requireNonNull(sourceFiles, "No template files found in the provided directory")) {
            KubernetesResource dto = (KubernetesResource)ResourceUtil.load((File)sourceFile, KubernetesResource.class, (ResourceFileType)ResourceFileType.yaml);
            if (dto instanceof Template) {
                ret.add((Template)dto);
                continue;
            }
            if (!(dto instanceof KubernetesList)) continue;
            Optional.ofNullable(((KubernetesList)dto).getItems()).map(Collection::stream).map(items -> items.filter(Template.class::isInstance).map(item -> (Template)item).collect(Collectors.toList())).ifPresent(ret::addAll);
        }
        return ret;
    }

    private void initHelmTypes() {
        Optional.ofNullable(this.getProperty(PROPERTY_TYPE)).filter(StringUtils::isNotBlank).map(types -> StringUtils.split((String)types, (String)",")).map(Stream::of).map(s -> s.map(prop -> HelmConfig.HelmType.valueOf((String)prop.trim().toUpperCase())).collect(Collectors.toList())).ifPresent(arg_0 -> ((HelmConfig)this.helm).setTypes(arg_0));
        if (this.helm.getTypes() == null || this.helm.getTypes().isEmpty()) {
            this.helm.setTypes(Collections.singletonList(this.getDefaultHelmType()));
        }
    }

    void initFromPropertyOrDefault(String property, Supplier<String> getter, Consumer<String> setter, String defaultValue) {
        Optional.ofNullable(this.getProperty(property)).filter(StringUtils::isNotBlank).ifPresent(setter);
        if (StringUtils.isBlank((CharSequence)getter.get())) {
            setter.accept(defaultValue);
        }
    }
}

