/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.KubernetesList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.ConstraintViolationException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.common.util.ResourceMojoUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.validator.ResourceValidator;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.MappingConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.EnricherManager;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.ResourceServiceConfig;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.kit.resource.service.DefaultResourceService;
import org.eclipse.jkube.maven.plugin.enricher.DefaultEnricherManager;
import org.eclipse.jkube.maven.plugin.generator.GeneratorManager;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractJKubeMojo {
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @Parameter(property="jkube.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/jkube")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    private File resourceDir;
    @Parameter(property="jkube.environment")
    private String environment;
    @Parameter(property="jkube.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="jkube.workDir", defaultValue="${project.build.directory}/jkube")
    private File workDir;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="jkube.skipResourceValidation", defaultValue="false")
    private Boolean skipResourceValidation;
    @Parameter(property="jkube.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="jkube.profile")
    private String profile;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    @Parameter
    private List<MappingConfig> mappings;
    @Parameter(property="jkube.namespace")
    private String namespace;
    @Parameter(property="jkube.skip.resource", defaultValue="false")
    protected boolean skipResource;
    @Parameter(property="jkube.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Parameter(property="jkube.mergeWithDekorate", defaultValue="false")
    private Boolean mergeWithDekorate;
    @Parameter(property="jkube.interpolateTemplateParameters", defaultValue="true")
    private Boolean interpolateTemplateParameters;
    @Component
    private MavenProjectHelper projectHelper;
    private File realResourceDir;

    @Override
    protected boolean canExecute() {
        return super.canExecute() && !this.skipResource;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        if (ResourceMojoUtil.useDekorate((MavenProject)this.project) && this.mergeWithDekorate.booleanValue()) {
            this.log.info("Dekorate detected, merging JKube and Dekorate resources", new Object[0]);
            System.setProperty("dekorate.input.dir", "META-INF/jkube");
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
        } else if (ResourceMojoUtil.useDekorate((MavenProject)this.project)) {
            this.log.info("Dekorate detected, delegating resource build", new Object[0]);
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
            return;
        }
        this.updateKindFilenameMappings();
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasJKubeDir())) {
                ResourceClassifier resourceClassifier = this.getResourceClassifier();
                KubernetesList resourceList = this.generateResources();
                File resourceClassifierDir = new File(this.targetDir, resourceClassifier.getValue());
                this.validateIfRequired(resourceClassifierDir, resourceClassifier);
                File artifact = this.jkubeServiceHub.getResourceService().writeResources(resourceList, resourceClassifier, this.log);
                this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), resourceClassifier.getValue(), artifact);
            }
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to generate kubernetes descriptor", (Exception)e);
        }
    }

    @Override
    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    @Override
    protected JKubeServiceHub.JKubeServiceHubBuilder initJKubeServiceHubBuilder(JavaProject javaProject) {
        this.realResourceDir = ResourceUtil.getFinalResourceDir((File)this.resourceDir, (String)this.environment);
        if (this.namespace != null && !this.namespace.isEmpty()) {
            this.resources = ResourceConfig.toBuilder((ResourceConfig)this.resources).namespace(this.namespace).build();
        }
        ResourceServiceConfig resourceServiceConfig = ResourceServiceConfig.builder().project(javaProject).resourceDir(this.realResourceDir).targetDir(this.targetDir).resourceFileType(this.resourceFileType).resourceConfig(this.resources).resourceFilesProcessor(resourceFiles -> this.mavenFilterFiles(resourceFiles, this.workDir)).interpolateTemplateParameters(this.interpolateTemplateParameters.booleanValue()).build();
        return super.initJKubeServiceHubBuilder(javaProject).resourceService(new LazyBuilder(() -> new DefaultResourceService(resourceServiceConfig)));
    }

    protected PlatformMode getPlatformMode() {
        return PlatformMode.kubernetes;
    }

    protected ResourceClassifier getResourceClassifier() {
        return ResourceClassifier.KUBERNETES;
    }

    private void updateKindFilenameMappings() {
        if (this.mappings != null) {
            HashMap<String, List<String>> mappingKindFilename = new HashMap<String, List<String>>();
            for (MappingConfig mappingConfig : this.mappings) {
                if (mappingConfig.isValid()) {
                    mappingKindFilename.put(mappingConfig.getKind(), Arrays.asList(mappingConfig.getFilenamesAsArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
            }
            KubernetesResourceUtil.updateKindFilenameMapper(mappingKindFilename);
        }
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Djkube.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate kubernetes descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Exception e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        RuntimeMode runtimeMode = this.getRuntimeMode();
        this.jkubeServiceHub.setPlatformMode(runtimeMode);
        if (runtimeMode.equals((Object)RuntimeMode.OPENSHIFT)) {
            Properties properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespaceToBeUsed = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespaceToBeUsed, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespaceToBeUsed);
            }
            if (!properties.contains("jkube.internal.effective.platform.mode")) {
                properties.setProperty("jkube.internal.effective.platform.mode", runtimeMode.toString());
            }
        }
    }

    private KubernetesList generateResources() throws IOException, DependencyResolutionRequiredException {
        JKubeEnricherContext.JKubeEnricherContextBuilder ctxBuilder = JKubeEnricherContext.builder().project(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session)).processorConfig(this.extractEnricherConfig()).settings((Collection)MavenUtil.getRegistryServerFromMavenSettings((Settings)this.settings)).resources(this.resources).images(this.resolvedImages).log(this.log);
        DefaultEnricherManager enricherManager = new DefaultEnricherManager((EnricherContext)ctxBuilder.build(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath));
        return this.jkubeServiceHub.getResourceService().generateResources(this.getPlatformMode(), (EnricherManager)enricherManager, this.log);
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.generator);
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, KitLogger log) throws MojoExecutionException, DependencyResolutionRequiredException {
        JavaProject jkubeProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
        List ret = ConfigHelper.resolveImages((KitLogger)log, images, image -> this.imageConfigResolver.resolve(image, jkubeProject), null, configs -> {
            try {
                GeneratorContext ctx = GeneratorContext.builder().config(this.extractGeneratorConfig()).project(jkubeProject).runtimeMode(this.getRuntimeMode()).logger(log).strategy(JKubeBuildStrategy.docker).useProjectClasspath(this.useProjectClasspath).build();
                return GeneratorManager.generate(configs, ctx, true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot extract generator: " + e, e);
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        if (DockerFileUtil.isSimpleDockerFileMode((File)this.project.getBasedir())) {
            File topDockerfile = DockerFileUtil.getTopLevelDockerfile((File)this.project.getBasedir());
            if (ret.isEmpty()) {
                ret.add(DockerFileUtil.createSimpleDockerfileConfig((File)topDockerfile, (String)MavenUtil.getPropertiesWithSystemOverrides((MavenProject)this.project).getProperty("jkube.image.name")));
            } else if (ret.size() == 1 && ((ImageConfiguration)ret.get(0)).getBuildConfiguration() == null) {
                ret.set(0, DockerFileUtil.addSimpleDockerfileConfig((ImageConfiguration)this.resolvedImages.get(0), (File)topDockerfile));
            }
        }
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session), now));
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        File tsFile = new File(this.project.getBuild().getDirectory(), DOCKER_BUILD_TIMESTAMP);
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)e);
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws IOException {
        if (resourceFiles == null) {
            return new File[0];
        }
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new IOException(String.format("Cannot filter %s to %s", resource, targetFile), exp);
            }
        }
        return ret;
    }

    private boolean hasJKubeDir() {
        return this.realResourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

