/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.common.util.ResourceMojoUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.ValidationUtil;
import org.eclipse.jkube.kit.common.util.validator.ResourceValidator;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.MappingConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ResourceVersioning;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.profile.Profile;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.maven.plugin.enricher.EnricherManager;
import org.eclipse.jkube.maven.plugin.generator.GeneratorManager;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractJKubeMojo {
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    private static final String DOCKER_IMAGE_USER = "docker.image.user";
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/jkube")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    private File resourceDir;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.environment")
    private String environment;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.workDir", defaultValue="${project.build.directory}/jkube")
    private File workDir;
    @org.apache.maven.plugins.annotations.Parameter
    private ResourceConfig resources;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.skipResourceValidation", defaultValue="false")
    private Boolean skipResourceValidation;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @org.apache.maven.plugins.annotations.Parameter
    private List<ImageConfiguration> images;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.profile")
    private String profile;
    @org.apache.maven.plugins.annotations.Parameter
    private ProcessorConfig enricher;
    @org.apache.maven.plugins.annotations.Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    @org.apache.maven.plugins.annotations.Parameter
    private List<MappingConfig> mappings;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.namespace")
    private String namespace;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.skip.resource", defaultValue="false")
    protected boolean skipResource;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @org.apache.maven.plugins.annotations.Parameter(property="jkube.mergeWithDekorate", defaultValue="false")
    private Boolean mergeWithDekorate;
    @Component
    private MavenProjectHelper projectHelper;
    private File realResourceDir;

    protected static Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    public static File writeResourcesIndividualAndComposite(KubernetesList resources, File resourceFileBase, ResourceFileType resourceFileType, KitLogger log) throws MojoExecutionException {
        KubernetesList entity = resources;
        Template template = ResourceMojo.getSingletonTemplate(resources);
        if (template != null) {
            entity = template;
        }
        File file = ResourceMojo.writeResource(resourceFileBase, entity, resourceFileType);
        ResourceMojo.writeIndividualResources(resources, resourceFileBase, resourceFileType, log);
        return file;
    }

    private static void writeIndividualResources(KubernetesList resources, File targetDir, ResourceFileType resourceFileType, KitLogger log) throws MojoExecutionException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.error("No name for generated item %s", new Object[]{item});
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            File itemTarget = new File(targetDir, itemFile);
            ResourceMojo.writeResource(itemTarget, item, resourceFileType);
        }
    }

    private static File writeResource(File resourceFileBase, Object entity, ResourceFileType resourceFileType) throws MojoExecutionException {
        try {
            return ResourceUtil.save((File)resourceFileBase, (Object)entity, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write resource to " + resourceFileBase + ". " + e, (Exception)e);
        }
    }

    @Override
    protected boolean canExecute() {
        return super.canExecute() && !this.skipResource;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        if (ResourceMojoUtil.useDekorate((MavenProject)this.project) && this.mergeWithDekorate.booleanValue()) {
            this.log.info("Dekorate detected, merging JKube and Dekorate resources", new Object[0]);
            System.setProperty("dekorate.input.dir", "META-INF/jkube");
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
        } else if (ResourceMojoUtil.useDekorate((MavenProject)this.project)) {
            this.log.info("Dekorate detected, delegating resource build", new Object[0]);
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
            return;
        }
        this.realResourceDir = ResourceUtil.getFinalResourceDir((File)this.resourceDir, (String)this.environment);
        this.updateKindFilenameMappings();
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasJKubeDir())) {
                PlatformMode platformMode = this.getPlatformMode();
                ResourceClassifier resourceClassifier = this.getResourceClassifier();
                KubernetesList resourceList = this.generateResources(platformMode, this.resolvedImages);
                File resourceClassifierDir = new File(this.targetDir, resourceClassifier.getValue());
                this.validateIfRequired(resourceClassifierDir, resourceClassifier);
                this.writeResources(resourceList, resourceClassifier);
            }
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to generate kubernetes descriptor", (Exception)e);
        }
    }

    protected PlatformMode getPlatformMode() {
        return PlatformMode.kubernetes;
    }

    @Override
    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    protected ResourceClassifier getResourceClassifier() {
        return ResourceClassifier.KUBERNETES;
    }

    private void updateKindFilenameMappings() {
        if (this.mappings != null) {
            HashMap<String, List<String>> mappingKindFilename = new HashMap<String, List<String>>();
            for (MappingConfig mappingConfig : this.mappings) {
                if (mappingConfig.isValid()) {
                    mappingKindFilename.put(mappingConfig.getKind(), Arrays.asList(mappingConfig.getFilenamesAsArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Invalid mapping for Kind %s and Filename Types %s", mappingConfig.getKind(), mappingConfig.getFilenameTypes()));
            }
            KubernetesResourceUtil.updateKindFilenameMapper(mappingKindFilename);
        }
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Djkube.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate kubernetes descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Exception e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        RuntimeMode runtimeMode = this.getRuntimeMode();
        this.jkubeServiceHub.setPlatformMode(runtimeMode);
        if (runtimeMode.equals((Object)RuntimeMode.OPENSHIFT)) {
            Properties properties = this.project.getProperties();
            if (!properties.contains(DOCKER_IMAGE_USER)) {
                String namespaceToBeUsed = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespaceToBeUsed, new Object[0]);
                properties.setProperty(DOCKER_IMAGE_USER, namespaceToBeUsed);
            }
            if (!properties.contains("jkube.internal.effective.platform.mode")) {
                properties.setProperty("jkube.internal.effective.platform.mode", runtimeMode.toString());
            }
        }
    }

    private KubernetesList generateResources(PlatformMode platformMode, List<ImageConfiguration> images) throws IOException, MojoExecutionException, DependencyResolutionRequiredException {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            this.resources = ResourceConfig.toBuilder((ResourceConfig)this.resources).namespace(this.namespace).build();
        }
        JavaProject jkubeProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
        JKubeEnricherContext.JKubeEnricherContextBuilder ctxBuilder = JKubeEnricherContext.builder().project(jkubeProject).processorConfig(this.extractEnricherConfig()).settings((Collection)MavenUtil.getRegistryServerFromMavenSettings((Settings)this.settings)).resources(this.resources).images(this.resolvedImages).log(this.log);
        EnricherManager enricherManager = new EnricherManager((EnricherContext)ctxBuilder.build(), MavenUtil.getCompileClasspathElementsIfRequested((MavenProject)this.project, (boolean)this.useProjectClasspath));
        KubernetesListBuilder builder = this.generateAppResources(platformMode, images, enricherManager);
        this.addProfiledResourcesFromSubdirectories(platformMode, builder, this.realResourceDir, enricherManager);
        return builder.build();
    }

    private void addProfiledResourcesFromSubdirectories(PlatformMode platformMode, KubernetesListBuilder builder, File resourceDir, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        File[] profileDirs = resourceDir.listFiles(File::isDirectory);
        if (profileDirs != null) {
            for (File profileDir : profileDirs) {
                Profile foundProfile = ProfileUtil.findProfile((String)profileDir.getName(), (File)resourceDir);
                ProcessorConfig enricherConfig = foundProfile.getEnricherConfig();
                File[] resourceFiles = KubernetesHelper.listResourceFragments((File)profileDir);
                if (resourceFiles.length <= 0) continue;
                KubernetesListBuilder profileBuilder = this.readResourceFragments(platformMode, resourceFiles);
                enricherManager.createDefaultResources(platformMode, enricherConfig, profileBuilder);
                enricherManager.enrich(platformMode, enricherConfig, profileBuilder);
                KubernetesList profileItems = profileBuilder.build();
                for (HasMetadata item : profileItems.getItems()) {
                    builder.addToItems(new HasMetadata[]{item});
                }
            }
        }
    }

    private KubernetesListBuilder generateAppResources(PlatformMode platformMode, List<ImageConfiguration> images, EnricherManager enricherManager) throws IOException, MojoExecutionException {
        try {
            KubernetesListBuilder builder = this.processResourceFragments(platformMode);
            enricherManager.createDefaultResources(platformMode, builder);
            enricherManager.enrich(platformMode, builder);
            return builder;
        }
        catch (ConstraintViolationException e) {
            String message = ValidationUtil.createValidationMessage((Set)e.getConstraintViolations());
            this.log.error("ConstraintViolationException: %s", new Object[]{message});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    private KubernetesListBuilder processResourceFragments(PlatformMode platformMode) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesHelper.listResourceFragments((File)this.realResourceDir, (List)(this.resources != null ? this.resources.getRemotes() : null), (KitLogger)this.log);
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("using resource templates from %s", new Object[]{this.realResourceDir});
            builder = this.readResourceFragments(platformMode, resourceFiles);
        } else {
            builder = new KubernetesListBuilder();
        }
        return builder;
    }

    private KubernetesListBuilder readResourceFragments(PlatformMode platformMode, File[] resourceFiles) throws IOException, MojoExecutionException {
        String defaultName = JKubeProjectUtil.createDefaultResourceName((String)this.project.getArtifactId(), (String[])new String[0]);
        KubernetesListBuilder builder = KubernetesResourceUtil.readResourceFragmentsFrom((PlatformMode)platformMode, (ResourceVersioning)KubernetesResourceUtil.DEFAULT_RESOURCE_VERSIONING, (String)defaultName, (File[])this.mavenFilterFiles(resourceFiles, this.workDir));
        return builder;
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.realResourceDir, (ProcessorConfig)this.generator);
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, KitLogger log) throws MojoExecutionException, DependencyResolutionRequiredException {
        JavaProject jkubeProject = MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session);
        List ret = ConfigHelper.resolveImages((KitLogger)log, images, image -> this.imageConfigResolver.resolve(image, jkubeProject), null, configs -> {
            try {
                GeneratorContext ctx = GeneratorContext.builder().config(this.extractGeneratorConfig()).project(jkubeProject).runtimeMode(this.getRuntimeMode()).logger(log).strategy(JKubeBuildStrategy.docker).useProjectClasspath(this.useProjectClasspath).build();
                return GeneratorManager.generate(configs, ctx, true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot extract generator: " + e, e);
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        if (DockerFileUtil.isSimpleDockerFileMode((File)this.project.getBasedir())) {
            File topDockerfile = DockerFileUtil.getTopLevelDockerfile((File)this.project.getBasedir());
            if (ret.isEmpty()) {
                ret.add(DockerFileUtil.createSimpleDockerfileConfig((File)topDockerfile, (String)MavenUtil.getPropertiesWithSystemOverrides((MavenProject)this.project).getProperty("jkube.image.name")));
            } else if (ret.size() == 1 && ((ImageConfiguration)ret.get(0)).getBuildConfiguration() == null) {
                ret.set(0, DockerFileUtil.addSimpleDockerfileConfig((ImageConfiguration)this.resolvedImages.get(0), (File)topDockerfile));
            }
        }
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session), now));
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        File tsFile = new File(this.project.getBuild().getDirectory(), DOCKER_BUILD_TIMESTAMP);
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)e);
        }
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws MojoExecutionException {
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private boolean hasJKubeDir() {
        return this.realResourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }

    protected void writeResources(KubernetesList resources, ResourceClassifier classifier) throws MojoExecutionException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        File file = ResourceMojo.writeResourcesIndividualAndComposite(resources, resourceFileBase, this.resourceFileType, this.log);
        this.resolveTemplateVariablesIfAny(resources, resourceFileBase, file);
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
    }

    private void resolveTemplateVariablesIfAny(KubernetesList resources, File kubernetesResourceDir, File resourceYaml) throws MojoExecutionException {
        Template template = this.findTemplate(resources);
        if (template != null) {
            List parameters = template.getParameters();
            if (parameters == null || parameters.isEmpty()) {
                return;
            }
            this.resolveTemplateVariables(parameters, resourceYaml);
            File[] kubernetesResources = kubernetesResourceDir.listFiles((dir, filename) -> filename.endsWith(".yml"));
            if (kubernetesResources != null) {
                for (File kubernetesResource : kubernetesResources) {
                    this.resolveTemplateVariables(parameters, kubernetesResource);
                }
            }
        }
    }

    private void resolveTemplateVariables(List<Parameter> parameters, File kubernetesYaml) throws MojoExecutionException {
        String text;
        try {
            text = FileUtils.readFileToString((File)kubernetesYaml, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load " + kubernetesYaml + " so we can replace template expressions " + e, (Exception)e);
        }
        String original = text;
        for (Parameter parameter : parameters) {
            String from = "${" + parameter.getName() + "}";
            String to = parameter.getValue();
            text = text.replace(from, to);
        }
        if (!original.equals(text)) {
            try {
                FileUtils.writeStringToFile((File)kubernetesYaml, (String)text, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to save " + kubernetesYaml + " after replacing template expressions " + e, (Exception)e);
            }
        }
    }

    private Template findTemplate(KubernetesList resources) {
        return resources.getItems().stream().filter(template -> template instanceof Template).findFirst().orElse(null);
    }
}

