/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Response;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchException;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.watcher.standard.ExecListenerLatch;

public class PodExecutor {
    private final ClusterAccess clusterAccess;
    private final InputStream readingInput;
    private final Duration waitTimeout;
    private final Consumer<Response> onOpen;
    private final ObjectMapper objectMapper;
    private String output;

    public PodExecutor(ClusterAccess clusterAccess, Duration waitTimeout) {
        this(clusterAccess, null, waitTimeout, null);
    }

    public PodExecutor(ClusterAccess clusterAccess, InputStream readingInput, Duration waitTimeout, Consumer<Response> onOpen) {
        this.clusterAccess = clusterAccess;
        this.readingInput = readingInput;
        this.waitTimeout = waitTimeout;
        this.onOpen = onOpen;
        this.objectMapper = new ObjectMapper();
    }

    void executeCommandInPod(Collection<HasMetadata> resources, String command) throws IOException, InterruptedException, WatchException {
        try (KubernetesClient client = this.clusterAccess.createDefaultClient();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream error = new ByteArrayOutputStream();){
            String namespace = this.clusterAccess.getNamespace();
            ExecListenerLatch latch = new ExecListenerLatch(this.onOpen);
            ExecWatch execWatch = (ExecWatch)((Execable)((TtyExecable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(KubernetesHelper.getNewestApplicationPodName((KubernetesClient)client, (String)namespace, resources))).readingInput((Object)this.readingInput)).writingOutput((Object)outputStream)).writingError((Object)outputStream)).writingErrorChannel((Object)error)).usingListener((Object)latch)).exec((Object[])new String[]{"sh", "-c", command});
            boolean completed = latch.await(this.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
            execWatch.close();
            this.output = outputStream.toString();
            if (!completed) {
                throw new WatchException("Command execution timed out");
            }
            if (latch.getCloseCode() != 1000) {
                throw new WatchException("Command execution socket closed unexpectedly " + latch.getCloseReason());
            }
            Map status = (Map)this.objectMapper.readValue(error.toString(), Map.class);
            if (status.getOrDefault("status", "Failure").equals("Failure")) {
                throw new WatchException("Command execution failed: " + status.getOrDefault("message", ""));
            }
        }
        catch (KubernetesClientException e) {
            throw new WatchException("Execution failed due to a KubernetesClient error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getOutput() {
        return this.output;
    }
}

