/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.standard;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.build.service.docker.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchContext;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.watcher.api.BaseWatcher;
import org.eclipse.jkube.watcher.api.WatcherContext;
import org.eclipse.jkube.watcher.standard.PodExecutor;

public class DockerImageWatcher
extends BaseWatcher {
    private static final Duration WAIT_TIMEOUT = Duration.ofSeconds(60L);

    public DockerImageWatcher(WatcherContext watcherContext) {
        super(watcherContext, "docker-image");
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Collection<HasMetadata> resources, PlatformMode mode) {
        return mode == PlatformMode.kubernetes;
    }

    public void watch(List<ImageConfiguration> configs, Collection<HasMetadata> resources, PlatformMode mode) {
        WatchContext watchContext = this.getContext().getWatchContext();
        watchContext = watchContext.toBuilder().imageCustomizer(this::buildImage).containerRestarter(imageWatcher -> this.restartContainer((WatchService.ImageWatcher)imageWatcher, resources)).containerCommandExecutor(command -> this.executeCommandInPod(command, resources)).containerCopyTask(f -> this.copyFileToPod(f, resources)).build();
        ServiceHub hub = this.getContext().getJKubeServiceHub().getDockerServiceHub();
        try {
            hub.getWatchService().watch(watchContext, this.getContext().getBuildContext(), configs);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while watching", ex);
        }
    }

    protected void buildImage(ImageConfiguration imageConfig) {
        String imageName = imageConfig.getName();
        try {
            String imagePrefix = this.getImagePrefix(imageName);
            imageName = imagePrefix + "%t";
            ImageNameFormatter formatter = new ImageNameFormatter(this.getContext().getBuildContext().getProject(), new Date());
            imageName = formatter.format(imageName);
            imageConfig.setName(imageName);
            this.log.info("New image name: " + imageConfig.getName(), new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Caught: " + e, new Object[]{e});
        }
    }

    private String getImagePrefix(String imageName) {
        int idx = imageName.lastIndexOf(58);
        if (idx < 0) {
            throw new IllegalStateException("No ':' in the image name:  " + imageName);
        }
        String imagePrefix = imageName.substring(0, idx + 1);
        return imagePrefix;
    }

    protected void restartContainer(WatchService.ImageWatcher watcher, Collection<HasMetadata> resources) {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        String imageName = imageConfig.getName();
        ClusterAccess clusterAccess = this.getContext().getJKubeServiceHub().getClusterAccess();
        try (KubernetesClient client = clusterAccess.createDefaultClient();){
            String namespace = clusterAccess.getNamespace();
            String imagePrefix = this.getImagePrefix(imageName);
            for (HasMetadata entity : resources) {
                this.updateImageName(client, namespace, entity, imagePrefix, imageName);
            }
        }
        catch (KubernetesClientException e) {
            KubernetesHelper.handleKubernetesClientException((KubernetesClientException)e, (KitLogger)this.log);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void updateImageName(KubernetesClient kubernetes, String namespace, HasMetadata entity, String imagePrefix, String imageName) {
        DeploymentConfig resource;
        DeploymentConfigSpec spec;
        String name = KubernetesHelper.getName((HasMetadata)entity);
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null && this.updateImageName(entity, spec2.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource2);
                ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().deployments().inNamespace(namespace)).withName(name)).rolling()).restart();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null && this.updateImageName(entity, spec3.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource3);
                ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)kubernetes.apps().replicaSets().inNamespace(namespace)).withName(name)).rolling()).restart();
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource4 = (ReplicationController)entity;
            ReplicationControllerSpec spec4 = resource4.getSpec();
            if (spec4 != null && this.updateImageName(entity, spec4.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource4);
                ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).rolling()).restart();
            }
        } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null && this.updateImageName(entity, spec.getTemplate(), imagePrefix, imageName)) {
            OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
            if (openshiftClient == null) {
                this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
            } else {
                ((DeployableScalableResource)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
            }
        }
    }

    private String executeCommandInPod(String command, Collection<HasMetadata> resources) throws IOException, WatchException {
        ClusterAccess clusterAccess = this.getContext().getJKubeServiceHub().getClusterAccess();
        try {
            PodExecutor podExecutor = new PodExecutor(clusterAccess, WAIT_TIMEOUT);
            podExecutor.executeCommandInPod(resources, command);
            return podExecutor.getOutput();
        }
        catch (InterruptedException exception) {
            this.log.error("Execute command task interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private void copyFileToPod(File fileToUpload, Collection<HasMetadata> resources) throws IOException, WatchException {
        ClusterAccess clusterAccess = this.getContext().getJKubeServiceHub().getClusterAccess();
        try (PipedOutputStream pos = new PipedOutputStream();
             PipedInputStream pis = new PipedInputStream(pos);){
            Consumer<Response> filePusher = DockerImageWatcher.uploadFilesConsumer(fileToUpload, pos, (KitLogger)this.log);
            PodExecutor podExecutor = new PodExecutor(clusterAccess, pis, WAIT_TIMEOUT, filePusher);
            podExecutor.executeCommandInPod(resources, "sh");
        }
        catch (InterruptedException exception) {
            this.log.error("Copy files task interrupted", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private boolean updateImageName(HasMetadata entity, PodTemplateSpec template, String imagePrefix, String imageName) {
        List containers;
        boolean answer = false;
        PodSpec spec = template.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                String image = container.getImage();
                if (image == null || !image.startsWith(imagePrefix)) continue;
                container.setImage(imageName);
                this.log.info("Updating " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to use image: " + imageName, new Object[0]);
                answer = true;
            }
        }
        return answer;
    }

    static Consumer<Response> uploadFilesConsumer(File fileToUpload, PipedOutputStream pos, KitLogger log) {
        return response -> {
            try (PrintWriter pw = new PrintWriter(pos, true);){
                pw.println("base64 -d << EOF | tar --no-overwrite-dir -C / -xf - && exit 0 || exit 1");
                IOUtils.copy((InputStream)new Base64InputStream((InputStream)new FileInputStream(fileToUpload), true, 0, new byte[]{13, 10}), (OutputStream)pos);
                pw.println();
                pw.println("EOF");
                pw.flush();
            }
            catch (IOException e) {
                log.error("Error uploading files to Pod", new Object[0]);
            }
        };
    }
}

