/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.generator;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SpringBootConfigurationHelper;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class SpringBootGenerator
extends JavaExecGenerator {
    private static final String DEFAULT_SERVER_PORT = "8080";

    public SpringBootGenerator(GeneratorContext context) {
        super(context, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && JKubeProjectUtil.hasPluginOfAnyArtifactId((JavaProject)this.getProject(), (String)"spring-boot-maven-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean isPrePackagePhase) {
        if (this.getContext().getGeneratorMode() == GeneratorMode.WATCH) {
            this.ensureSpringDevToolSecretToken();
            if (!isPrePackagePhase) {
                this.addDevToolsFilesToFatJar();
            }
        }
        return super.customize(configs, isPrePackagePhase);
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        String secret;
        Map res = super.getEnv(prePackagePhase);
        if (this.getContext().getGeneratorMode() == GeneratorMode.WATCH && (secret = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)this.getProject()), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getProject())).getProperty("spring.devtools.remote.secret")) != null) {
            res.put("SPRING_DEVTOOLS_REMOTE_SECRET", secret);
        }
        return res;
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        String configuredColor = this.getConfig(Config.COLOR);
        if (StringUtils.isNotBlank((CharSequence)configuredColor)) {
            opts.add("-Dspring.output.ansi.enabled=" + configuredColor);
        }
        return opts;
    }

    protected boolean isFatJar() {
        if (!this.hasMainClass() && this.isSpringBootRepackage()) {
            return true;
        }
        return super.isFatJar();
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)this.getProject()), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getProject()));
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(SpringBootUtil.getSpringBootVersion((JavaProject)this.getProject()));
        String port = properties.getProperty(propertyHelper.getServerPortPropertyKey(), DEFAULT_SERVER_PORT);
        SpringBootGenerator.addPortIfValid(answer, (String)this.getConfig((Configs.Config)JavaExecGenerator.Config.WEB_PORT, port));
        SpringBootGenerator.addPortIfValid(answer, (String)this.getConfig((Configs.Config)JavaExecGenerator.Config.JOLOKIA_PORT));
        SpringBootGenerator.addPortIfValid(answer, (String)this.getConfig((Configs.Config)JavaExecGenerator.Config.PROMETHEUS_PORT));
        return answer;
    }

    private void ensureSpringDevToolSecretToken() {
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)this.getProject()), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getProject()));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret");
        if (Strings.isNullOrEmpty((String)remoteSecret)) {
            this.addSecretTokenToApplicationProperties();
            throw new IllegalStateException("No spring.devtools.remote.secret found in application.properties. Plugin has added it, please re-run goals");
        }
    }

    private void addDevToolsFilesToFatJar() {
        if (this.isFatJar()) {
            File target = this.getFatJarFile();
            try {
                File devToolsFile = this.getSpringBootDevToolsJar();
                File applicationPropertiesFile = new File(this.getProject().getBaseDirectory(), "target/classes/application.properties");
                this.copyFilesToFatJar(Collections.singletonList(devToolsFile), Collections.singletonList(applicationPropertiesFile), target);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to add devtools files to fat jar " + target + ". " + e, e);
            }
        }
    }

    private File getFatJarFile() {
        FatJarDetector.Result fatJarDetectResult = this.detectFatJar();
        if (fatJarDetectResult == null) {
            throw new IllegalStateException("No fat jar built yet. Please ensure that the 'package' phase has run");
        }
        return fatJarDetectResult.getArchiveFile();
    }

    private void copyFilesToFatJar(List<File> libs, List<File> classes, File target) throws IOException {
        File tmpZip = File.createTempFile(target.getName(), null);
        tmpZip.delete();
        FileUtils.moveFile((File)target, (File)tmpZip);
        byte[] buffer = new byte[8192];
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(target));){
            Throwable throwable;
            FileInputStream in;
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                if (!this.matchesFatJarEntry(libs, ze.getName(), true) && !this.matchesFatJarEntry(classes, ze.getName(), false)) {
                    out.putNextEntry(ze);
                    int read = zin.read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = zin.read(buffer);
                    }
                    out.closeEntry();
                }
                ze = zin.getNextEntry();
            }
            for (File lib : libs) {
                in = new FileInputStream(lib);
                throwable = null;
                try {
                    out.putNextEntry(this.createZipEntry(lib, this.getFatJarFullPath(lib, true)));
                    int read = ((InputStream)in).read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = ((InputStream)in).read(buffer);
                    }
                    out.closeEntry();
                }
                catch (Throwable read) {
                    throwable = read;
                    throw read;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable read) {
                            throwable.addSuppressed(read);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            for (File cls : classes) {
                in = new FileInputStream(cls);
                throwable = null;
                try {
                    out.putNextEntry(this.createZipEntry(cls, this.getFatJarFullPath(cls, false)));
                    int read = ((InputStream)in).read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = ((InputStream)in).read(buffer);
                    }
                    out.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
        }
        tmpZip.delete();
    }

    private boolean matchesFatJarEntry(List<File> fatJarEntries, String path, boolean lib) {
        for (File e : fatJarEntries) {
            String fullPath = this.getFatJarFullPath(e, lib);
            if (!fullPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private String getFatJarFullPath(File file, boolean lib) {
        if (lib) {
            return "BOOT-INF/lib/" + file.getName();
        }
        return "BOOT-INF/classes/" + file.getName();
    }

    private ZipEntry createZipEntry(File file, String fullPath) throws IOException {
        ZipEntry entry = new ZipEntry(fullPath);
        byte[] buffer = new byte[8192];
        int bytesRead = -1;
        try (FileInputStream is = new FileInputStream(file);){
            CRC32 crc = new CRC32();
            int size = 0;
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
                size += bytesRead;
            }
            entry.setSize(size);
            entry.setCompressedSize(size);
            entry.setCrc(crc.getValue());
            entry.setMethod(0);
            ZipEntry zipEntry = entry;
            return zipEntry;
        }
    }

    private void addSecretTokenToApplicationProperties() {
        String newToken = UUID.randomUUID().toString();
        this.log.verbose("Generating the spring devtools token in property: spring.devtools.remote.secret", new Object[0]);
        this.appendSecretTokenToFile("target/classes/application.properties", newToken);
        this.appendSecretTokenToFile("src/main/resources/application.properties", newToken);
    }

    private void appendSecretTokenToFile(String path, String token) {
        File file = new File(this.getProject().getBaseDirectory(), path);
        file.getParentFile().mkdirs();
        String text = String.format("%s# Remote secret added by jkube-kit-plugin\n%s=%s\n", file.exists() ? "\n" : "", "spring.devtools.remote.secret", token);
        try (FileWriter writer = new FileWriter(file, true);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to append to file: " + file + ". " + e, e);
        }
    }

    private boolean isSpringBootRepackage() {
        JavaProject project = this.getProject();
        Plugin plugin = JKubeProjectUtil.getPlugin((JavaProject)project, (String)"spring-boot-maven-plugin");
        if (Optional.ofNullable(plugin).map(Plugin::getExecutions).map(e -> e.contains("repackage")).orElse(false).booleanValue()) {
            this.log.verbose("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
            return true;
        }
        return false;
    }

    private File getSpringBootDevToolsJar() {
        String version = (String)SpringBootUtil.getSpringBootDevToolsVersion((JavaProject)this.getProject()).orElseThrow(() -> new IllegalStateException("Unable to find the spring-boot version"));
        File devToolsJar = this.getContext().getArtifactResolver().resolveArtifact("org.springframework.boot", "spring-boot-devtools", version, "jar");
        if (!devToolsJar.exists()) {
            throw new IllegalArgumentException("devtools need to be included in repacked archive, please set <excludeDevtools> to false in plugin configuration");
        }
        return devToolsJar;
    }

    public static enum Config implements Configs.Config
    {
        COLOR("color", "");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

