/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.Serialization;

public class SpringBootLayeredJar {
    private final File layeredJar;
    private final KitLogger kitLogger;

    public SpringBootLayeredJar(File layeredJar, KitLogger kitLogger) {
        this.layeredJar = layeredJar;
        this.kitLogger = kitLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLayeredJar() {
        try (JarFile jarFile = new JarFile(this.layeredJar);){
            boolean bl = jarFile.getEntry("BOOT-INF/layers.idx") != null && StringUtils.isNotBlank((CharSequence)this.getMainClass());
            return bl;
        }
        catch (Exception e) {
            this.kitLogger.debug("Couldn't determine if Spring Boot jar %s is layered", new Object[]{this.layeredJar.getName(), e});
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public String getMainClass() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listLayers() {
        try (JarFile jarFile = new JarFile(this.layeredJar);){
            List layers = (List)Serialization.unmarshal((InputStream)jarFile.getInputStream(jarFile.getEntry("BOOT-INF/layers.idx")), List.class);
            if (layers == null) {
                throw new IOException("Unable to find layers information in BOOT-INF/layers.idx file");
            }
            List<String> list = layers.stream().flatMap(m -> m.keySet().stream()).collect(Collectors.toList());
            return list;
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failure in getting spring boot jar layers information", ioException);
        }
    }

    public void extractLayers(File extractionDir) {
        try {
            new LayerToolsCommand(this.kitLogger, extractionDir, this.layeredJar, "extract").execute();
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failure in extracting spring boot jar layers", ioException);
        }
    }

    private static class LayerToolsCommand
    extends ExternalCommand {
        private final File layeredJar;
        private final String[] args;

        protected LayerToolsCommand(KitLogger log, File workDir, File layeredJar, String ... args) {
            super(log, workDir);
            this.layeredJar = layeredJar;
            this.args = args;
        }

        protected String[] getArgs() {
            return (String[])ArrayUtils.addAll((Object[])new String[]{"java", "-Djarmode=layertools", "-jar", this.layeredJar.getAbsolutePath()}, (Object[])this.args);
        }
    }
}

