/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.keyverifier.StaticServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.remotedev.LocalService;
import org.eclipse.jkube.kit.remotedev.RemoteDevelopmentContext;
import org.eclipse.jkube.kit.remotedev.RemoteService;

class PortForwarder
implements Callable<Void> {
    private static final String LOCALHOST = "localhost";
    private final RemoteDevelopmentContext context;
    private final KitLogger logger;
    private final AtomicBoolean stop;

    PortForwarder(RemoteDevelopmentContext context) {
        this.context = context;
        this.logger = context.getLogger();
        this.stop = new AtomicBoolean(false);
    }

    @Override
    public Void call() throws InterruptedException {
        this.logger.debug("Starting port forwarder...", new Object[0]);
        while (true) {
            this.waitForUser();
            this.waitForServices();
            SshClient sshClient = this.startSshClient();
            try (ClientSession session = this.createSession(sshClient);){
                session.auth().verify(10L, TimeUnit.SECONDS);
                this.forwardRemotePorts(session);
                this.forwardLocalPorts(session);
                this.socksProxy(session);
                session.waitFor(Arrays.asList(ClientSession.ClientSessionEvent.CLOSED, ClientSession.ClientSessionEvent.TIMEOUT), Duration.ofHours(1L));
            }
            catch (Exception ex) {
                this.logger.warn("JKube remote development session disconnected, retrying in 5 seconds: %s", new Object[]{ex.getMessage()});
            }
            if (this.stop.get()) {
                sshClient.stop();
                return null;
            }
            TimeUnit.SECONDS.sleep(5L);
        }
    }

    void stop() {
        this.stop.set(true);
    }

    private SshClient startSshClient() {
        SecurityUtils.setAPrioriDisabledProvider((String)"EdDSA", (boolean)true);
        SshClient sshClient = SshClient.setUpDefaultClient();
        sshClient.setUserAuthFactories(Collections.singletonList(UserAuthPublicKeyFactory.INSTANCE));
        sshClient.setIoServiceFactoryFactory(BuiltinIoServiceFactoryFactories.NIO2.create());
        sshClient.setHostConfigEntryResolver(HostConfigEntryResolver.EMPTY);
        sshClient.setGlobalRequestHandlers(Collections.singletonList(new GlobalRequestHandler(this.logger)));
        sshClient.setForwardingFilter((ForwardingFilter)AcceptAllForwardingFilter.INSTANCE);
        sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllNoLoggingServerKeyVerifier.INSTANCE);
        sshClient.setKeyIdentityProvider(KeyIdentityProvider.wrapKeyPairs((KeyPair[])new KeyPair[]{this.context.getClientKeys()}));
        sshClient.start();
        return sshClient;
    }

    private ClientSession createSession(SshClient sshClient) throws IOException {
        return (ClientSession)((ConnectFuture)sshClient.connect(this.context.getUser(), LOCALHOST, this.context.getSshPort()).verify(10L, TimeUnit.SECONDS)).getSession();
    }

    private void waitForUser() throws InterruptedException {
        this.logger.debug("Waiting for remote container to log current user", new Object[0]);
        while (this.context.getUser() == null) {
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    private void waitForServices() throws InterruptedException {
        this.logger.debug("Waiting for remote services to be created", new Object[0]);
        while (!this.context.getManagedServices().keySet().containsAll(this.context.getRemoteDevelopmentConfig().getLocalServices())) {
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    private void forwardRemotePorts(ClientSession session) throws IOException {
        for (RemoteService remoteService : this.context.getRemoteDevelopmentConfig().getRemoteServices()) {
            session.startLocalPortForwarding(remoteService.getLocalPort(), new SshdSocketAddress(remoteService.getHostname(), remoteService.getPort()));
            this.logger.info("Kubernetes Service %s:%s is now available at local port %s", new Object[]{remoteService.getHostname(), remoteService.getPort(), remoteService.getLocalPort()});
        }
    }

    private void forwardLocalPorts(ClientSession session) throws IOException {
        for (Map.Entry<LocalService, Service> managedService : this.context.getManagedServices().entrySet()) {
            int localPort = managedService.getKey().getPort();
            int remotePort = Optional.ofNullable(managedService.getValue().getSpec()).map(ServiceSpec::getPorts).map(p -> (ServicePort)p.iterator().next()).map(ServicePort::getTargetPort).map(IntOrString::getIntVal).orElse(localPort);
            session.startRemotePortForwarding(new SshdSocketAddress("", remotePort), new SshdSocketAddress(LOCALHOST, managedService.getKey().getPort()));
            this.logger.info("Local port '%s' is now available as a Kubernetes Service at %s:%s", new Object[]{localPort, managedService.getKey().getServiceName(), remotePort});
        }
    }

    private void socksProxy(ClientSession session) throws IOException {
        int socksPort = this.context.getRemoteDevelopmentConfig().getSocksPort();
        if (socksPort > 0 && socksPort <= 65535) {
            session.startDynamicPortForwarding(new SshdSocketAddress(LOCALHOST, socksPort));
            this.logger.info("SOCKS 5 proxy is now available at 'localhost:%s'", new Object[]{socksPort});
        } else {
            this.logger.debug("SOCKS 5 proxy is disabled", new Object[0]);
        }
    }

    private static final class AcceptAllNoLoggingServerKeyVerifier
    extends StaticServerKeyVerifier {
        private static final AcceptAllNoLoggingServerKeyVerifier INSTANCE = new AcceptAllNoLoggingServerKeyVerifier();

        public AcceptAllNoLoggingServerKeyVerifier() {
            super(true);
        }

        protected void handleAcceptance(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        }
    }

    private static final class GlobalRequestHandler
    implements RequestHandler<ConnectionService> {
        private final KitLogger logger;

        public GlobalRequestHandler(KitLogger logger) {
            this.logger = logger;
        }

        public RequestHandler.Result process(ConnectionService o, String request, boolean wantReply, Buffer buffer) {
            if (!request.equals("hostkeys-00@openssh.com")) {
                this.logger.warn("Received unknown global request: %s", new Object[]{request});
            }
            return RequestHandler.Result.ReplyFailure;
        }
    }
}

