/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.webapp.handler.AbstractAppServerHandler;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;

public class TomcatAppSeverHandler
extends AbstractAppServerHandler {
    private static final String TOMCAT_GROUPID = "org.apache.tomcat.maven";

    public TomcatAppSeverHandler(GeneratorContext context) {
        super("tomcat", context);
    }

    @Override
    public boolean isApplicable() {
        try {
            return this.hasOneOf("glob:**/META-INF/context.xml") || this.hasTomcatMavenPlugin();
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to scan output directory: ", exception);
        }
    }

    private boolean hasTomcatMavenPlugin() {
        return Stream.of("tomcat6-maven-plugin", "tomcat7-maven-plugin", "tomcat8-maven-plugin").anyMatch(artifactId -> JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)TOMCAT_GROUPID, (String)artifactId));
    }

    @Override
    public String getFrom() {
        return this.imageLookup.getImageName("tomcat.upstream.docker");
    }

    @Override
    public String getDeploymentDir() {
        return "/deployments";
    }

    @Override
    public String getCommand() {
        return "/usr/local/s2i/run";
    }

    @Override
    public boolean supportsS2iBuild() {
        return true;
    }
}

