/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.webapp.handler.AbstractAppServerHandler;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class WildFlyAppSeverHandler
extends AbstractAppServerHandler {
    private static final String HANDLER_NAME = "wildfly";
    private static final String PROPERTY_IMAGE_NAME = "wildfly";
    private final FromSelector fromSelector;

    public WildFlyAppSeverHandler(GeneratorContext context) {
        super("wildfly", context);
        this.fromSelector = new FromSelector.Default(context, "wildfly");
    }

    @Override
    public boolean isApplicable() {
        try {
            return this.isNotWildflySwarm() && this.isNotThorntail() && (this.isWildFlyWebApp() || this.hasWildFlyPlugin()) && this.isNotWildFlyJAR();
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to scan output directory: ", exception);
        }
    }

    private boolean hasWildFlyPlugin() {
        return JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.jboss.as.plugins", (String)"jboss-as-maven-plugin") || JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.wildfly.plugins", (String)"wildfly-maven-plugin");
    }

    private boolean isWildFlyWebApp() throws IOException {
        return this.hasOneOf("glob:**/WEB-INF/jboss-deployment-structure.xml", "glob:**/META-INF/jboss-deployment-structure.xml", "glob:**/WEB-INF/jboss-web.xml", "glob:**/WEB-INF/ejb-jar.xml", "glob:**/WEB-INF/jboss-ejb3.xml", "glob:**/META-INF/persistence.xml", "glob:**/META-INF/*-jms.xml", "glob:**/WEB-INF/*-jms.xml", "glob:**/META-INF/*-ds.xml", "glob:**/WEB-INF/*-ds.xml", "glob:**/WEB-INF/jboss-ejb-client.xml", "glob:**/META-INF/jbosscmp-jdbc.xml", "glob:**/WEB-INF/jboss-webservices.xml");
    }

    private boolean isNotWildflySwarm() {
        return !JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.wildfly.swarm", (String)"wildfly-swarm-plugin");
    }

    private boolean isNotThorntail() {
        return !JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"io.thorntail", (String)"thorntail-maven-plugin");
    }

    private boolean isNotWildFlyJAR() {
        return !JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.wildfly.plugins", (String)"wildfly-jar-maven-plugin");
    }

    @Override
    public String getFrom() {
        return this.fromSelector.getFrom();
    }

    @Override
    public String getDeploymentDir() {
        if (this.generatorContext.getRuntimeMode() == RuntimeMode.OPENSHIFT && this.generatorContext.getStrategy() == JKubeBuildStrategy.s2i) {
            return "/deployments";
        }
        return "/opt/jboss/wildfly/standalone/deployments";
    }

    @Override
    public String getCommand() {
        return "/opt/jboss/wildfly/bin/standalone.sh -b 0.0.0.0";
    }

    @Override
    public Map<String, String> getEnv() {
        return Collections.singletonMap("GALLEON_PROVISION_LAYERS", "cloud-server,web-clustering");
    }

    @Override
    public String getUser() {
        return "jboss:jboss:jboss";
    }

    @Override
    public List<String> runCmds() {
        if (this.generatorContext.getRuntimeMode() == RuntimeMode.OPENSHIFT && this.generatorContext.getStrategy() == JKubeBuildStrategy.docker) {
            return Collections.singletonList("chmod -R a+rw /opt/jboss/wildfly/standalone/");
        }
        return super.runCmds();
    }

    @Override
    public boolean supportsS2iBuild() {
        return true;
    }
}

