/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.webapp.handler.AbstractAppServerHandler;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;

public class JettyAppSeverHandler
extends AbstractAppServerHandler {
    private static final String JETTY_MAVEN_PLUGIN_ARTIFACT_ID = "jetty-maven-plugin";

    public JettyAppSeverHandler(GeneratorContext context) {
        super("jetty", context);
    }

    @Override
    public boolean isApplicable() {
        try {
            return this.isJettyWebApp() || this.hasJettyMavenPlugin();
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to scan output directory: ", exception);
        }
    }

    private boolean isJettyWebApp() throws IOException {
        return this.hasOneOf("glob:**/WEB-INF/jetty-web.xml", "glob:**/META-INF/jetty-logging.properties");
    }

    private boolean hasJettyMavenPlugin() {
        return Stream.of("org.mortbay.jetty", "org.eclipse.jetty").anyMatch(groupId -> JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)groupId, (String)JETTY_MAVEN_PLUGIN_ARTIFACT_ID));
    }

    @Override
    public String getFrom() {
        return this.imageLookup.getImageName("jetty.upstream.docker");
    }

    @Override
    public String getDeploymentDir() {
        return "/deployments";
    }

    @Override
    public String getCommand() {
        return "/usr/local/s2i/run";
    }

    @Override
    public boolean supportsS2iBuild() {
        return true;
    }
}

