/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.javaexec;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;

class MainClassDetector {
    private String mainClass = null;
    private final File classesDir;
    private final KitLogger log;

    MainClassDetector(String mainClass, File classesDir, KitLogger log) {
        this.mainClass = mainClass;
        this.classesDir = classesDir;
        this.log = log;
    }

    String getMainClass() {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        try {
            List foundMainClasses = ClassUtil.findMainClasses((File)this.classesDir);
            if (foundMainClasses.isEmpty()) {
                this.mainClass = null;
                return null;
            }
            if (foundMainClasses.size() == 1) {
                this.mainClass = (String)foundMainClasses.get(0);
                return this.mainClass;
            }
            this.log.warn("Found more than one main class : %s. Ignoring ....", new Object[]{foundMainClasses});
            this.mainClass = null;
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not examine main classes: " + e, e);
        }
    }
}

