/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.javaexec;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.generator.javaexec.MainClassDetector;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class JavaExecGenerator
extends BaseGenerator {
    static final String JAVA_MAIN_CLASS_ENV_VAR = "JAVA_MAIN_CLASS";
    private static final String JAVA_OPTIONS = "JAVA_OPTIONS";
    private static final String[][] JAVA_EXEC_MAVEN_PLUGINS = new String[][]{{"org.codehaus.mojo", "exec-maven-plugin"}, {"org.apache.maven.plugins", "maven-shade-plugin"}};
    private final FatJarDetector fatJarDetector = new FatJarDetector(this.getProject().getBuildDirectory());
    private final MainClassDetector mainClassDetector;

    public JavaExecGenerator(GeneratorContext context) {
        this(context, "java-exec");
    }

    protected JavaExecGenerator(GeneratorContext context, String name) {
        super(context, name, (FromSelector)new FromSelector.Default(context, "java"));
        this.mainClassDetector = new MainClassDetector(this.getConfig(Config.MAIN_CLASS), this.getProject().getOutputDirectory(), context.getLogger());
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        if (this.shouldAddGeneratedImageConfiguration(configs)) {
            if (this.getConfig(Config.MAIN_CLASS) != null) {
                return true;
            }
            for (String[] plugin : JAVA_EXEC_MAVEN_PLUGINS) {
                if (!JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)plugin[0], (String)plugin[1])) continue;
                return true;
            }
        }
        return false;
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        ImageConfiguration.ImageConfigurationBuilder imageBuilder = ImageConfiguration.builder();
        BuildConfiguration.BuildConfigurationBuilder buildBuilder = BuildConfiguration.builder();
        buildBuilder.ports(this.extractPorts());
        this.addSchemaLabels(buildBuilder, this.log);
        this.addFrom(buildBuilder);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly());
        }
        Map<String, String> envMap = this.getEnv(prePackagePhase);
        envMap.put("JAVA_APP_DIR", this.getConfig(Config.TARGET_DIR));
        buildBuilder.env(envMap);
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).registry(this.getRegistry()).alias(this.getAlias()).build(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        List<String> javaOptions;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.isFatJar()) {
            String mainClass = this.getConfig(Config.MAIN_CLASS);
            if (mainClass == null && (mainClass = this.mainClassDetector.getMainClass()) == null && !prePackagePhase) {
                throw new IllegalStateException("Cannot extract main class to startup");
            }
            if (mainClass != null) {
                this.log.verbose("Detected main class %s", new Object[]{mainClass});
                ret.put(JAVA_MAIN_CLASS_ENV_VAR, mainClass);
            }
        }
        if (!(javaOptions = this.getExtraJavaOptions()).isEmpty()) {
            ret.put(JAVA_OPTIONS, StringUtils.join(javaOptions.iterator(), (String)" "));
        }
        return ret;
    }

    protected List<String> getExtraJavaOptions() {
        return new ArrayList<String>();
    }

    protected AssemblyConfiguration createAssembly() {
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = AssemblyConfiguration.builder();
        builder.targetDir(this.getConfig(Config.TARGET_DIR));
        this.addAssembly(builder);
        builder.name("deployments");
        return builder.build();
    }

    protected void addAssembly(AssemblyConfiguration.AssemblyConfigurationBuilder builder) {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>(this.addAdditionalFiles());
        if (this.isFatJar()) {
            builder.excludeFinalOutputArtifact(true);
            FatJarDetector.Result fatJar = this.detectFatJar();
            if (fatJar != null) {
                fileSets.add(this.getOutputDirectoryFileSet(fatJar, this.getProject()));
            }
        } else {
            this.log.warn("No fat Jar detected, make sure your image assembly configuration contains all the required dependencies for your application to run.", new Object[0]);
        }
        builder.inline(Assembly.builder().fileSets(fileSets).build());
    }

    public List<AssemblyFileSet> addAdditionalFiles() {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>();
        fileSets.add(this.createFileSet("src/main/jkube-includes/bin", "bin", "0755"));
        fileSets.add(this.createFileSet("src/main/jkube-includes", ".", "0644"));
        return fileSets;
    }

    public AssemblyFileSet getOutputDirectoryFileSet(FatJarDetector.Result fatJar, JavaProject project) {
        File buildDirectory = project.getBuildDirectory();
        return AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)buildDirectory)).include(FileUtil.getRelativePath((File)buildDirectory, (File)fatJar.getArchiveFile()).getPath()).outputDirectory(new File(".")).fileMode("0640").build();
    }

    public AssemblyFileSet createFileSet(String sourceDir, String outputDir, String fileMode) {
        return AssemblyFileSet.builder().directory(new File(sourceDir)).outputDirectory(new File(outputDir)).fileMode(fileMode).build();
    }

    protected boolean isFatJar() {
        return !this.hasMainClass() && this.detectFatJar() != null;
    }

    protected boolean hasMainClass() {
        return this.getConfig(Config.MAIN_CLASS) != null;
    }

    public FatJarDetector.Result detectFatJar() {
        return this.fatJarDetector.scan();
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.WEB_PORT));
        this.addPortIfValid(answer, this.getConfig(Config.JOLOKIA_PORT));
        this.addPortIfValid(answer, this.getConfig(Config.PROMETHEUS_PORT));
        return answer;
    }

    protected void addPortIfValid(List<String> list, String port) {
        if (StringUtils.isNotBlank((CharSequence)port) && Integer.parseInt(port) > 0) {
            list.add(port);
        }
    }

    public static enum Config implements Configs.Config
    {
        WEB_PORT("webPort", "8080"),
        JOLOKIA_PORT("jolokiaPort", "8778"),
        PROMETHEUS_PORT("prometheusPort", "9779"),
        TARGET_DIR("targetDir", "/deployments"),
        MAIN_CLASS("mainClass", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

