/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api.support;

import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.PortsExtractor;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.PrefixedLogger;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;

public abstract class AbstractPortsExtractor
implements PortsExtractor {
    private static final String DOT = ".";
    private static final String JSON_EXTENSION = ".json";
    private static final String YAML_EXTENSION = ".yaml";
    private static final String YML_EXTENSION = ".yml";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String NUMBER_REGEX = "\\d+";
    private static final String PORT_REGEX = "([a-zA-Z0-9_]+)(([\\.-_]+p)|([P]))ort";
    private static final Pattern PORT_PATTERN = Pattern.compile("([a-zA-Z0-9_]+)(([\\.-_]+p)|([P]))ort");
    protected final PrefixedLogger log;

    public AbstractPortsExtractor(PrefixedLogger log) {
        this.log = log;
    }

    public abstract String getConfigPathPropertyName();

    public abstract String getConfigPathFromProject(JavaProject var1);

    public File getConfigLocation(JavaProject project) {
        String propertyName = this.getConfigPathPropertyName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return null;
        }
        String configPath = Configs.getFromSystemPropertyWithPropertiesAsFallback((Properties)project.getProperties(), (String)this.getConfigPathPropertyName());
        if (configPath == null) {
            configPath = this.getConfigPathFromProject(project);
        }
        if (StringUtils.isBlank((CharSequence)configPath)) {
            return null;
        }
        return Paths.get(configPath, new String[0]).toFile();
    }

    @Override
    public Map<String, Integer> extract(JavaProject project) {
        HashMap<String, Integer> answer = new HashMap<String, Integer>();
        File configFile = this.getConfigLocation(project);
        if (configFile == null) {
            return answer;
        }
        if (!configFile.exists()) {
            this.log.warn("Could not find config: %s. Ignoring.", new Object[]{configFile.getAbsolutePath()});
            return answer;
        }
        try {
            Map<String, String> configMap = this.readConfig(configFile);
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                String key = entry.getKey();
                if (!this.isValidPortPropertyKey(key)) continue;
                this.addPortIfValid(answer, key, entry.getValue());
            }
            return answer;
        }
        catch (IOException e) {
            this.log.warn("Error reading config: [%s], due to: [%s]. Ignoring.", new Object[]{configFile.getAbsolutePath(), e.getMessage()});
            return answer;
        }
    }

    private Map<String, String> readConfig(File f) throws IOException {
        Map map;
        if (f.getName().endsWith(JSON_EXTENSION)) {
            map = this.flatten((Map)Serialization.jsonMapper().readValue(f, Map.class));
        } else if (f.getName().endsWith(YAML_EXTENSION) || f.getName().endsWith(YML_EXTENSION)) {
            map = this.flatten((Map)Serialization.yamlMapper().readValue(f, Map.class));
        } else if (f.getName().endsWith(PROPERTIES_EXTENSION)) {
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(f);){
                properties.load(fis);
            }
            map = PropertiesUtil.toMap((Properties)properties);
        } else {
            throw new IllegalArgumentException("Can't read configuration from: [" + f.getName() + "]. Unknown file extension.");
        }
        return map;
    }

    private Map<String, String> flatten(Map map) {
        HashMap<String, String> flat = new HashMap<String, String>();
        Set mapEntrySet = map.entrySet();
        for (Map.Entry mapEntry : mapEntrySet) {
            String stringKey = String.valueOf(mapEntry.getKey());
            Object value = mapEntry.getValue();
            if (value instanceof String) {
                flat.put(stringKey, (String)value);
                continue;
            }
            if (value instanceof Map) {
                for (Map.Entry<String, String> entry : this.flatten((Map)value).entrySet()) {
                    flat.put(stringKey + DOT + entry.getKey(), entry.getValue());
                }
                continue;
            }
            flat.put(stringKey, String.valueOf(value));
        }
        return flat;
    }

    private boolean isValidPortPropertyKey(String candidate) {
        return PORT_PATTERN.matcher(candidate).matches();
    }

    private void addPortIfValid(Map<String, Integer> map, String key, String port) {
        String t;
        if (StringUtils.isNotBlank((CharSequence)port) && (t = port.trim()).matches(NUMBER_REGEX)) {
            map.put(key, Integer.parseInt(t));
        }
    }
}

