/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.Generator;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.build.api.config.property.PropertyConfigResolver;
import org.eclipse.jkube.kit.build.api.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.image.GeneratorManager;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class DefaultGeneratorManager
implements GeneratorManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/generator-default", "META-INF/jkube/jkube-generator-default", "META-INF/jkube/generator", "META-INF/jkube-generator"};
    private final GeneratorContext genCtx;
    private final PropertyConfigResolver propertyConfigResolver;

    public DefaultGeneratorManager(GeneratorContext context) {
        this.genCtx = context;
        this.propertyConfigResolver = new PropertyConfigResolver();
        this.addOpenShiftBuildRelatedProperties();
    }

    public List<ImageConfiguration> generateAndMerge(List<ImageConfiguration> unresolvedImages) {
        List<ImageConfiguration> resolvedImages = this.resolveImages(unresolvedImages);
        List<ImageConfiguration> generatedImages = this.generateImages(resolvedImages);
        List<ImageConfiguration> filteredImages = this.filterImages(generatedImages);
        ImageNameFormatter imageNameFormatter = new ImageNameFormatter(this.genCtx.getProject(), this.genCtx.getBuildTimestamp());
        for (ImageConfiguration imageConfiguration : filteredImages) {
            BuildConfiguration buildConfiguration;
            imageConfiguration.setName(imageNameFormatter.format(imageConfiguration.getName()));
            if (imageConfiguration.getBuild() != null) {
                BuildConfiguration updatedBuildConfig = this.mergeGlobalConfigParamsWithSingleImageBuildConfig(imageConfiguration.getBuild());
                imageConfiguration.setBuild(updatedBuildConfig);
                imageConfiguration.getBuild().initAndValidate();
            }
            if ((buildConfiguration = imageConfiguration.getBuildConfiguration()) == null || !buildConfiguration.isDockerFileMode()) continue;
            this.genCtx.getLogger().info("Using Dockerfile: %s", new Object[]{buildConfiguration.getDockerFile().getAbsolutePath()});
            this.genCtx.getLogger().info("Using Docker Context Directory: %s", new Object[]{buildConfiguration.getAbsoluteContextDirPath(this.genCtx.getSourceDirectory(), this.genCtx.getProject().getBaseDirectory().getAbsolutePath())});
        }
        return filteredImages;
    }

    private List<ImageConfiguration> resolveImages(List<ImageConfiguration> unresolvedImages) {
        ArrayList<ImageConfiguration> resolvedImages = new ArrayList<ImageConfiguration>();
        if (unresolvedImages != null) {
            for (ImageConfiguration unresolvedImage : unresolvedImages) {
                ImageConfiguration resolvedImage = this.propertyConfigResolver.resolve(unresolvedImage, this.genCtx.getProject());
                if (resolvedImage.getName() == null) {
                    throw new JKubeException("Configuration error: <image> must have a non-null <name>");
                }
                resolvedImages.add(resolvedImage);
            }
        }
        return resolvedImages;
    }

    private List<ImageConfiguration> generateImages(List<ImageConfiguration> imageConfigs) {
        List<ImageConfiguration> ret = imageConfigs;
        KitLogger log = this.genCtx.getLogger();
        List<Generator> usableGenerators = this.createUsableGeneratorList();
        log.verbose("Generators:", new Object[0]);
        for (Generator generator : usableGenerators) {
            log.verbose(" - %s", new Object[]{generator.getName()});
            if (!generator.isApplicable(ret)) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret, this.genCtx.isPrePackagePhase());
        }
        return ret;
    }

    private List<ImageConfiguration> filterImages(List<ImageConfiguration> imagesToFilter) {
        ArrayList<ImageConfiguration> filteredImages = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : imagesToFilter) {
            if (!this.matchesConfiguredImages(this.genCtx.getFilter(), imageConfig)) continue;
            filteredImages.add(imageConfig);
        }
        if (!imagesToFilter.isEmpty() && filteredImages.isEmpty() && this.genCtx.getFilter() != null) {
            List imageNames = imagesToFilter.stream().map(ImageConfiguration::getName).collect(Collectors.toList());
            this.genCtx.getLogger().warn("None of the resolved images [%s] match the configured filter '%s'", new Object[]{String.join((CharSequence)",", imageNames), this.genCtx.getFilter()});
        }
        return filteredImages;
    }

    private void addOpenShiftBuildRelatedProperties() {
        if (this.genCtx.getRuntimeMode() == RuntimeMode.OPENSHIFT) {
            Properties properties = this.genCtx.getProject().getProperties();
            String namespaceToBeUsed = this.genCtx.getOpenshiftNamespace();
            if (!properties.contains("jkube.image.user") && StringUtils.isNotBlank((CharSequence)namespaceToBeUsed)) {
                this.genCtx.getLogger().info("Using container image name of namespace: " + namespaceToBeUsed, new Object[0]);
                properties.setProperty("jkube.image.user", namespaceToBeUsed);
            }
            if (!properties.contains("jkube.internal.effective.platform.mode")) {
                properties.setProperty("jkube.internal.effective.platform.mode", this.genCtx.getRuntimeMode().toString());
            }
        }
    }

    private boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split(",")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private List<Generator> createUsableGeneratorList() {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)this.genCtx, new ClassLoader[0]);
        if (this.genCtx.isUseProjectClasspath()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((List)this.genCtx.getProject().getCompileClassPathElements(), (KitLogger)this.genCtx.getLogger()));
        }
        List generators = pluginFactory.createServiceObjects(SERVICE_PATHS);
        return this.genCtx.getConfig().prepareProcessors(generators, "generator");
    }

    private BuildConfiguration mergeGlobalConfigParamsWithSingleImageBuildConfig(BuildConfiguration build) {
        BuildConfiguration.BuildConfigurationBuilder buildConfigBuilder = build.toBuilder();
        if (!build.isOpenshiftForcePull() && this.genCtx.isOpenshiftForcePull()) {
            buildConfigBuilder.openshiftForcePull(true);
        }
        if (StringUtils.isBlank((CharSequence)build.getOpenshiftS2iBuildNameSuffix()) && StringUtils.isNotBlank((CharSequence)this.genCtx.getOpenshiftS2iBuildNameSuffix())) {
            buildConfigBuilder.openshiftS2iBuildNameSuffix(this.genCtx.getOpenshiftS2iBuildNameSuffix());
        }
        if (!build.isOpenshiftS2iImageStreamLookupPolicyLocal() && this.genCtx.isOpenshiftS2iImageStreamLookupPolicyLocal()) {
            buildConfigBuilder.openshiftS2iImageStreamLookupPolicyLocal(true);
        }
        if (StringUtils.isBlank((CharSequence)build.getOpenshiftPullSecret()) && StringUtils.isNotBlank((CharSequence)this.genCtx.getOpenshiftPullSecret())) {
            buildConfigBuilder.openshiftPullSecret(this.genCtx.getOpenshiftPullSecret());
        }
        if (StringUtils.isBlank((CharSequence)build.getOpenshiftPushSecret()) && StringUtils.isNotBlank((CharSequence)this.genCtx.getOpenshiftPushSecret())) {
            buildConfigBuilder.openshiftPushSecret(this.genCtx.getOpenshiftPushSecret());
        }
        if (StringUtils.isBlank((CharSequence)build.getOpenshiftBuildOutputKind()) && StringUtils.isNotBlank((CharSequence)this.genCtx.getOpenshiftBuildOutputKind())) {
            buildConfigBuilder.openshiftBuildOutputKind(this.genCtx.getOpenshiftBuildOutputKind());
        }
        if (build.getOpenshiftBuildRecreateMode() == null) {
            buildConfigBuilder.openshiftBuildRecreateMode(this.genCtx.getOpenshiftBuildRecreate());
        }
        return buildConfigBuilder.build();
    }
}

