/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.specific;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class WebAppHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public WebAppHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-webapp");
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.getProbe(false);
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.getProbe(true);
    }

    private boolean isApplicable() {
        return this.getContext().hasPlugin("org.apache.maven.plugins", "maven-war-plugin") && StringUtils.isNotEmpty((CharSequence)this.getConfig(Config.PATH));
    }

    private Probe getProbe(boolean readiness) {
        if (!this.isApplicable()) {
            return null;
        }
        Integer port = this.getPort();
        String scheme = this.getScheme().toUpperCase();
        String path = this.getPath();
        int delay = readiness ? this.getInitialReadinessDelay() : this.getInitialLivenessDelay();
        return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(delay))).build();
    }

    private int getInitialReadinessDelay() {
        return Configs.asInt((String)this.getConfig(Config.INITIAL_READINESS_DELAY));
    }

    private int getInitialLivenessDelay() {
        return Configs.asInt((String)this.getConfig(Config.INITIAL_LIVENESS_DELAY));
    }

    protected String getScheme() {
        return this.getConfig(Config.SCHEME);
    }

    protected int getPort() {
        return Configs.asInt((String)this.getConfig(Config.PORT));
    }

    protected String getPath() {
        return this.getConfig(Config.PATH);
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "8080"),
        PATH("path", ""),
        INITIAL_READINESS_DELAY("initialReadinessDelay", "10"),
        INITIAL_LIVENESS_DELAY("initialLivenessDelay", "180");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

