/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class StatefulSetHandler
implements ControllerHandler<StatefulSet> {
    private final PodTemplateHandler podTemplateHandler;

    StatefulSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public StatefulSet get(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetBuilder)((StatefulSetBuilder)new StatefulSetBuilder().withMetadata(this.createStatefulSetMetaData(config))).withSpec(this.createStatefulSetSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getTemplate();
    }

    @Override
    public PodTemplateSpec getPodTemplate(StatefulSet controller) {
        return controller.getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, final int replicas) {
        resources.accept(new Visitor[]{new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.SpecNested)builder.editOrNewSpec().withReplicas(Integer.valueOf(replicas))).endSpec();
            }
        }});
    }

    private ObjectMeta createStatefulSetMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private StatefulSetSpec createStatefulSetSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)new StatefulSetSpecBuilder().withReplicas(config.getReplicas())).withServiceName(config.getControllerName())).withTemplate(this.podTemplateHandler.getPodTemplate(config, config.getRestartPolicy(), images))).build();
    }
}

