/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecBuilder;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class JobHandler
implements ControllerHandler<Job> {
    private final PodTemplateHandler podTemplateHandler;
    private static final String DEFAULT_JOB_RESTART_POLICY = "OnFailure";

    JobHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public Job get(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobBuilder)((JobBuilder)new JobBuilder().withMetadata(this.createJobSpecMetaData(config))).withSpec(this.createJobSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getTemplate();
    }

    @Override
    public PodTemplateSpec getPodTemplate(Job controller) {
        return controller.getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, int replicas) {
    }

    private ObjectMeta createJobSpecMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private JobSpec createJobSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobSpecBuilder)new JobSpecBuilder().withTemplate(this.podTemplateHandler.getPodTemplate(config, Optional.ofNullable(config.getRestartPolicy()).orElse(DEFAULT_JOB_RESTART_POLICY), images))).build();
    }
}

