/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class ReplicationControllerHandler
implements ControllerHandler<ReplicationController> {
    private final PodTemplateHandler podTemplateHandler;

    ReplicationControllerHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public ReplicationController get(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerBuilder)((ReplicationControllerBuilder)new ReplicationControllerBuilder().withMetadata(this.createRcMetaData(config))).withSpec(this.createRcSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, final int replicas) {
        resources.accept(new Visitor[]{new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.SpecNested)builder.editOrNewSpec().withReplicas(Integer.valueOf(replicas))).endSpec();
            }
        }});
    }

    private ObjectMeta createRcMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"replication controller name"))).build();
    }

    private ReplicationControllerSpec createRcSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerSpecBuilder)((ReplicationControllerSpecBuilder)new ReplicationControllerSpecBuilder().withReplicas(config.getReplicas())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

