/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api.util;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.resource.ControllerResourceConfig;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.InitContainerConfig;
import org.eclipse.jkube.kit.config.resource.ResourceVersioning;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;

public class KubernetesResourceUtil {
    public static final String API_VERSION = "v1";
    public static final String EXTENSIONS_VERSION = "extensions/v1beta1";
    public static final String API_APPS_VERSION = "apps/v1";
    public static final String API_NETWORKING_VERSION = "networking.k8s.io/v1";
    public static final String JOB_VERSION = "batch/v1";
    public static final String OPENSHIFT_V1_VERSION = "apps.openshift.io/v1";
    public static final String CRONJOB_VERSION = "batch/v1beta1";
    public static final String RBAC_VERSION = "rbac.authorization.k8s.io/v1";
    public static final String API_EXTENSIONS_VERSION = "apiextensions.k8s.io/v1";
    public static final ResourceVersioning DEFAULT_RESOURCE_VERSIONING = ResourceVersioning.builder().withCoreVersion("v1").withExtensionsVersion("extensions/v1beta1").withAppsVersion("apps/v1").withNetworkingVersion("networking.k8s.io/v1").withJobVersion("batch/v1").withOpenshiftV1version("apps.openshift.io/v1").withRbacVersion("rbac.authorization.k8s.io/v1").withCronJobVersion("batch/v1beta1").withApiExtensionsVersion("apiextensions.k8s.io/v1").build();
    private static final Set<Class<?>> SIMPLE_FIELD_TYPES = new HashSet();
    private static final String CONTAINER_NAME_REGEX = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$";

    private KubernetesResourceUtil() {
    }

    public static void removeItemFromKubernetesBuilder(KubernetesListBuilder builder, HasMetadata item) {
        ArrayList<HasMetadata> newListItems = new ArrayList<HasMetadata>();
        for (HasMetadata listItem : builder.buildItems()) {
            if (listItem.equals(item)) continue;
            newListItems.add(listItem);
        }
        builder.withItems(newListItems);
    }

    public static String extractContainerName(GroupArtifactVersion groupArtifactVersion, ImageConfiguration imageConfig) {
        String containerName;
        String alias = imageConfig.getAlias();
        String string = containerName = alias != null ? alias : KubernetesResourceUtil.extractImageUser(imageConfig.getName(), groupArtifactVersion.getGroupId()) + "-" + groupArtifactVersion.getArtifactId();
        if (!containerName.matches(CONTAINER_NAME_REGEX)) {
            return KubernetesResourceUtil.sanitizeName(containerName);
        }
        return containerName;
    }

    private static String extractImageUser(String image, String groupId) {
        ImageName name = new ImageName(image);
        String imageUser = name.inferUser();
        if (imageUser != null) {
            return imageUser;
        }
        return groupId;
    }

    public static boolean checkForKind(KubernetesListBuilder builder, String ... kinds) {
        HashSet<String> kindSet = new HashSet<String>(Arrays.asList(kinds));
        for (HasMetadata item : builder.buildItems()) {
            if (!kindSet.contains(item.getKind())) continue;
            return true;
        }
        return false;
    }

    public static void validateKubernetesMasterUrl(URL masterUrl) {
        if (masterUrl == null || StringUtils.isBlank((CharSequence)masterUrl.toString())) {
            throw new IllegalStateException("Cannot find Kubernetes master URL. Are you sure if you're connected to a remote cluster via `kubectl`?");
        }
    }

    public static void handleKubernetesClientException(KubernetesClientException e, KitLogger logger) {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            logger.error("Could not connect to kubernetes cluster!", new Object[0]);
            logger.error("Connection error: %s", new Object[]{cause});
            String message = "Could not connect to kubernetes cluster. Are you sure if you're connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new IllegalStateException(message, (Throwable)e);
        }
        throw new IllegalStateException(e.getMessage(), (Throwable)e);
    }

    public static void mergeSimpleFields(Object targetValues, Object defaultValues) {
        Class<?> tc = targetValues.getClass();
        Class<?> sc = defaultValues.getClass();
        for (Method targetGetMethod : tc.getMethods()) {
            Class<?> fieldType;
            if (!targetGetMethod.getName().startsWith("get") || !KubernetesResourceUtil.isSimpleFieldType(fieldType = targetGetMethod.getReturnType())) continue;
            String fieldName = targetGetMethod.getName().substring(3);
            Method withMethod = null;
            try {
                withMethod = tc.getMethod("with" + fieldName, fieldType);
            }
            catch (NoSuchMethodException e) {
                try {
                    withMethod = tc.getMethod("set" + fieldName, fieldType);
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            Method sourceGetMethod = null;
            try {
                sourceGetMethod = sc.getMethod("get" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                if (targetGetMethod.invoke(targetValues, new Object[0]) != null) continue;
                withMethod.invoke(targetValues, sourceGetMethod.invoke(defaultValues, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static String mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName) {
        return KubernetesResourceUtil.mergePodSpec(builder, defaultPodSpec, defaultName, false);
    }

    public static String mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName, boolean sidecarEnabled) {
        String defaultApplicationContainerName = null;
        List containers = builder.buildContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    List defaultPorts;
                    Container container = null;
                    if (sidecarEnabled) {
                        for (Object fragmentContainer : containers) {
                            if (fragmentContainer.getName() != null && !fragmentContainer.getName().equals(defaultContainer.getName())) continue;
                            container = fragmentContainer;
                            defaultApplicationContainerName = defaultContainer.getName();
                            break;
                        }
                        if (container == null) {
                            container = new Container();
                            containers.add(container);
                        }
                    } else if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    if (defaultApplicationContainerName == null) {
                        if (container.getName() != null) {
                            defaultApplicationContainerName = container.getName();
                        } else if (defaultContainer.getName() != null) {
                            defaultApplicationContainerName = defaultContainer.getName();
                        }
                    }
                    KubernetesResourceUtil.mergeSimpleFields(container, defaultContainer);
                    List defaultEnv = defaultContainer.getEnv();
                    if (defaultEnv != null) {
                        Object fragmentContainer;
                        fragmentContainer = defaultEnv.iterator();
                        while (fragmentContainer.hasNext()) {
                            EnvVar envVar = (EnvVar)fragmentContainer.next();
                            KubernetesResourceUtil.ensureHasEnv(container, envVar);
                        }
                    }
                    if ((defaultPorts = defaultContainer.getPorts()) != null) {
                        for (ContainerPort port : defaultPorts) {
                            KubernetesResourceUtil.ensureHasPort(container, port);
                        }
                    }
                    if (container.getReadinessProbe() == null) {
                        container.setReadinessProbe(defaultContainer.getReadinessProbe());
                    }
                    if (container.getLivenessProbe() == null) {
                        container.setLivenessProbe(defaultContainer.getLivenessProbe());
                    }
                    if (container.getSecurityContext() == null) {
                        container.setSecurityContext(defaultContainer.getSecurityContext());
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        } else if (!containers.isEmpty()) {
            for (Container container : containers) {
                if (!StringUtils.isBlank((CharSequence)container.getName())) continue;
                container.setName(defaultName);
                break;
            }
            builder.withContainers(containers);
        }
        return defaultApplicationContainerName;
    }

    private static void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> envVars = container.getEnv();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
            container.setEnv(envVars);
        }
        for (EnvVar envVariable : envVars) {
            if (!Objects.equals(envVariable.getName(), envVar.getName())) continue;
            envVars.remove(envVariable);
            envVars.add(envVar);
            return;
        }
        envVars.add(envVar);
    }

    private static void ensureHasPort(Container container, ContainerPort port) {
        ArrayList<ContainerPort> ports = container.getPorts();
        if (ports == null) {
            ports = new ArrayList<ContainerPort>();
            container.setPorts(ports);
        }
        for (ContainerPort cp : ports) {
            String n1 = cp.getName();
            String n2 = port.getName();
            if (n1 != null && n2 != null && n1.equals(n2)) {
                return;
            }
            Integer p1 = cp.getContainerPort();
            Integer p2 = port.getContainerPort();
            if (p1 == null || p2 == null || p1.intValue() != p2.intValue()) continue;
            return;
        }
        ports.add(port);
    }

    private static boolean isSimpleFieldType(Class<?> type) {
        return SIMPLE_FIELD_TYPES.contains(type);
    }

    public static HasMetadata mergeResources(HasMetadata item1, HasMetadata item2, KitLogger log, boolean switchOnLocalCustomisation) {
        if (item1 instanceof Deployment && item2 instanceof Deployment) {
            return KubernetesResourceUtil.mergeDeployments((Deployment)item1, (Deployment)item2, log, switchOnLocalCustomisation);
        }
        if (item1 instanceof ConfigMap && item2 instanceof ConfigMap) {
            ConfigMap cm1 = (ConfigMap)item1;
            ConfigMap cm2 = (ConfigMap)item2;
            return KubernetesResourceUtil.mergeConfigMaps(cm1, cm2, log, switchOnLocalCustomisation);
        }
        KubernetesResourceUtil.mergeMetadata(item1, item2);
        return item1;
    }

    @Deprecated
    public static Map.Entry<String, String> createConfigMapEntry(String key, Path file) throws IOException {
        byte[] bytes = Files.readAllBytes(file);
        if (KubernetesResourceUtil.isFileWithBinaryContent(file)) {
            String value = Base64.getEncoder().encodeToString(bytes);
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }
        return new AbstractMap.SimpleEntry<String, String>(key, new String(bytes));
    }

    @Deprecated
    public static boolean isFileWithBinaryContent(Path file) throws IOException {
        byte[] bytes = Files.readAllBytes(file);
        try {
            StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(bytes));
            return false;
        }
        catch (CharacterCodingException e) {
            return true;
        }
    }

    @Deprecated
    public static void addNewEntriesFromDirectoryToExistingConfigMap(ConfigMapBuilder configMapBuilder, Path path) throws IOException {
        try (Stream<Path> files = Files.list(path);){
            files.filter(p -> !Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).forEach(file -> {
                try {
                    KubernetesResourceUtil.addNewEntryToExistingConfigMap(configMapBuilder, KubernetesResourceUtil.createConfigMapEntry(file.getFileName().toString(), file), file);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
    }

    @Deprecated
    public static void addNewEntryToExistingConfigMap(ConfigMapBuilder configMapBuilder, Map.Entry<String, String> entry, Path file) throws IOException {
        if (KubernetesResourceUtil.isFileWithBinaryContent(file)) {
            configMapBuilder.addToBinaryData(entry.getKey(), entry.getValue());
        } else {
            configMapBuilder.addToData(entry.getKey(), entry.getValue());
        }
    }

    public static void addNewConfigMapEntriesToExistingConfigMap(ConfigMapBuilder configMapBuilder, String key, Path filePath) throws IOException {
        if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
            KubernetesResourceUtil.addNewEntriesFromDirectoryToExistingConfigMap(configMapBuilder, filePath);
        } else {
            KubernetesResourceUtil.addNewEntryToExistingConfigMap(configMapBuilder, KubernetesResourceUtil.createConfigMapEntry(key, filePath), filePath);
        }
    }

    public static boolean hasInitContainer(PodTemplateSpecBuilder builder, String name) {
        return KubernetesResourceUtil.getInitContainer(builder, name) != null;
    }

    public static Container getInitContainer(PodTemplateSpecBuilder builder, String name) {
        if (Boolean.TRUE.equals(builder.hasSpec())) {
            List initContainerList = builder.buildSpec().getInitContainers();
            for (Container initContainer : initContainerList) {
                if (!initContainer.getName().equals(name)) continue;
                return initContainer;
            }
        }
        return null;
    }

    public static void removeInitContainer(PodTemplateSpecBuilder builder, String initContainerName) {
        Container initContainer = KubernetesResourceUtil.getInitContainer(builder, initContainerName);
        if (initContainer != null) {
            List initContainers = builder.buildSpec().getInitContainers();
            initContainers.remove(initContainer);
            ((PodTemplateSpecFluent.SpecNested)builder.editSpec().withInitContainers(initContainers)).endSpec();
        }
    }

    public static void appendInitContainer(PodTemplateSpecBuilder builder, Container initContainer, KitLogger log) {
        String name = initContainer.getName();
        Container existing = KubernetesResourceUtil.getInitContainer(builder, name);
        if (existing != null) {
            if (existing.equals((Object)initContainer)) {
                log.warn("Trying to add init-container %s a second time. Ignoring ....", new Object[]{name});
                return;
            }
            throw new IllegalArgumentException(String.format("PodSpec %s already contains a different init container with name %s but can not add a second one with the same name. Please choose a different name for the init container", builder.build().getMetadata().getName(), name));
        }
        KubernetesResourceUtil.ensureSpec(builder);
        ((PodTemplateSpecFluent.SpecNested)builder.editSpec().addToInitContainers(new Container[]{initContainer})).endSpec();
    }

    public static List<Container> createNewInitContainersFromConfig(List<InitContainerConfig> initContainerConfigs) {
        ArrayList<Container> initContainers = new ArrayList<Container>();
        for (InitContainerConfig initContainerConfig : initContainerConfigs) {
            initContainers.add(KubernetesResourceUtil.createNewInitContainerFromConfig(initContainerConfig));
        }
        return initContainers;
    }

    public static Container createNewInitContainerFromConfig(InitContainerConfig initContainerConfig) {
        ContainerBuilder containerBuilder = new ContainerBuilder();
        if (StringUtils.isNotBlank((CharSequence)initContainerConfig.getName())) {
            containerBuilder.withName(initContainerConfig.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)initContainerConfig.getImageName())) {
            containerBuilder.withImage(initContainerConfig.getImageName());
        }
        if (StringUtils.isNotBlank((CharSequence)initContainerConfig.getImagePullPolicy())) {
            containerBuilder.withImagePullPolicy(initContainerConfig.getImagePullPolicy());
        }
        if (initContainerConfig.getCmd() != null) {
            containerBuilder.withCommand(initContainerConfig.getCmd().asStrings());
        }
        if (initContainerConfig.getVolumes() != null && !initContainerConfig.getVolumes().isEmpty()) {
            containerBuilder.withVolumeMounts(KubernetesResourceUtil.createVolumeMountsFromConfig(initContainerConfig.getVolumes()));
        }
        if (initContainerConfig.getEnv() != null && !initContainerConfig.getEnv().isEmpty()) {
            containerBuilder.withEnv(KubernetesHelper.convertToEnvVarList((Map)initContainerConfig.getEnv()));
        }
        return containerBuilder.build();
    }

    public static boolean isContainerImage(ImageConfiguration imageConfig, ControllerResourceConfig config) {
        return imageConfig.getBuildConfiguration() != null && !KubernetesResourceUtil.isInitContainerImage(imageConfig, config);
    }

    public static boolean isInitContainerImage(ImageConfiguration imageConfiguration, ControllerResourceConfig config) {
        if (config.getInitContainers() != null && !config.getInitContainers().isEmpty()) {
            return config.getInitContainers().stream().map(InitContainerConfig::getImageName).collect(Collectors.toSet()).contains(imageConfiguration.getName());
        }
        return false;
    }

    private static void ensureSpec(PodTemplateSpecBuilder obj) {
        if (obj.buildSpec() == null) {
            obj.withNewSpec().endSpec();
        }
    }

    private static List<VolumeMount> createVolumeMountsFromConfig(List<VolumeConfig> volumeConfigs) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        for (VolumeConfig vc : volumeConfigs) {
            VolumeMountBuilder volumeMountBuilder = new VolumeMountBuilder();
            if (StringUtils.isNotBlank((CharSequence)vc.getName())) {
                volumeMountBuilder.withName(vc.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)vc.getPath())) {
                volumeMountBuilder.withMountPath(vc.getPath());
            }
            volumeMounts.add(volumeMountBuilder.build());
        }
        return volumeMounts;
    }

    protected static HasMetadata mergeConfigMaps(ConfigMap cm1, ConfigMap cm2, KitLogger log, boolean switchOnLocalCustomisation) {
        ConfigMap cm1OrCopy = cm1;
        if (!switchOnLocalCustomisation) {
            cm1OrCopy = new ConfigMapBuilder(cm1OrCopy).build();
        }
        log.info("Merging 2 resources for " + KubernetesHelper.getKind((KubernetesResource)cm1OrCopy) + " " + KubernetesHelper.getName((HasMetadata)cm1OrCopy), new Object[0]);
        cm1OrCopy.setData(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(cm2.getData(), cm1OrCopy.getData()));
        KubernetesResourceUtil.mergeMetadata((HasMetadata)cm1OrCopy, (HasMetadata)cm2);
        return cm1OrCopy;
    }

    protected static HasMetadata mergeDeployments(Deployment resource1, Deployment resource2, KitLogger log, boolean switchOnLocalCustomisation) {
        Deployment resource1OrCopy = resource1;
        if (!switchOnLocalCustomisation) {
            resource1OrCopy = new DeploymentBuilder(resource1OrCopy).build();
        }
        Deployment answer = resource1OrCopy;
        DeploymentSpec spec1 = resource1OrCopy.getSpec();
        DeploymentSpec spec2 = resource2.getSpec();
        if (spec1 == null) {
            resource1OrCopy.setSpec(spec2);
        } else {
            PodTemplateSpec template1 = spec1.getTemplate();
            PodTemplateSpec template2 = null;
            if (spec2 != null) {
                template2 = spec2.getTemplate();
            }
            if (template1 != null && template2 != null) {
                KubernetesResourceUtil.mergeMetadata(template1, template2);
            }
            if (template1 == null) {
                spec1.setTemplate(template2);
            } else {
                PodSpec podSpec1 = template1.getSpec();
                PodSpec podSpec2 = null;
                if (template2 != null) {
                    podSpec2 = template2.getSpec();
                }
                if (podSpec1 == null) {
                    template1.setSpec(podSpec2);
                } else {
                    String defaultName = null;
                    PodTemplateSpec updateTemplate = template1;
                    if (switchOnLocalCustomisation) {
                        Deployment override = resource2;
                        if (KubernetesResourceUtil.isLocalCustomisation(podSpec1)) {
                            updateTemplate = template2;
                            PodSpec tmp = podSpec1;
                            podSpec1 = podSpec2;
                            podSpec2 = tmp;
                        } else {
                            answer = resource2;
                            override = resource1OrCopy;
                        }
                        KubernetesResourceUtil.mergeMetadata((HasMetadata)answer, (HasMetadata)override);
                    } else {
                        KubernetesResourceUtil.mergeMetadata((HasMetadata)resource1OrCopy, (HasMetadata)resource2);
                    }
                    if (updateTemplate != null) {
                        if (podSpec2 == null) {
                            updateTemplate.setSpec(podSpec1);
                        } else {
                            PodSpecBuilder podSpecBuilder = new PodSpecBuilder(podSpec1);
                            KubernetesResourceUtil.mergePodSpec(podSpecBuilder, podSpec2, defaultName);
                            updateTemplate.setSpec(podSpecBuilder.build());
                        }
                    }
                    return answer;
                }
            }
        }
        log.info("Merging 2 resources for " + KubernetesHelper.getKind((KubernetesResource)resource1OrCopy) + " " + KubernetesHelper.getName((HasMetadata)resource1OrCopy), new Object[0]);
        return resource1OrCopy;
    }

    private static void mergeMetadata(PodTemplateSpec target, PodTemplateSpec source) {
        if (target != null && source != null) {
            ObjectMeta targetMeta = target.getMetadata();
            ObjectMeta sourceMeta = source.getMetadata();
            if (targetMeta == null) {
                target.setMetadata(sourceMeta);
            } else if (sourceMeta != null) {
                KubernetesResourceUtil.mergeMetadata(targetMeta, sourceMeta);
            }
        }
    }

    public static void mergeMetadata(HasMetadata target, HasMetadata source) {
        if (target != null && source != null) {
            ObjectMeta targetMeta = target.getMetadata();
            ObjectMeta sourceMeta = source.getMetadata();
            if (targetMeta == null) {
                target.setMetadata(sourceMeta);
            } else if (sourceMeta != null) {
                KubernetesResourceUtil.mergeMetadata(targetMeta, sourceMeta);
            }
        }
    }

    public static void mergeMetadata(ObjectMeta target, ObjectMeta source) {
        if (target != null && source != null) {
            target.setAnnotations(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(source.getAnnotations(), target.getAnnotations()));
            target.setLabels(KubernetesResourceUtil.mergeMapsAndRemoveEmptyStrings(source.getLabels(), target.getLabels()));
        }
    }

    private static Map<String, String> mergeMapsAndRemoveEmptyStrings(Map<String, String> overrideMap, Map<String, String> originalMap) {
        Map answer = MapUtil.mergeMaps(overrideMap, originalMap);
        if (overrideMap != null && originalMap != null) {
            Set<Map.Entry<String, String>> entries = overrideMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String value = entry.getValue();
                if (value != null && !value.isEmpty()) continue;
                String key = entry.getKey();
                answer.remove(key);
            }
        }
        return answer;
    }

    private static boolean isLocalCustomisation(PodSpec podSpec) {
        List containers = podSpec.getContainers() != null ? podSpec.getContainers() : Collections.emptyList();
        for (Container container : containers) {
            if (!StringUtils.isNotBlank((CharSequence)container.getImage())) continue;
            return false;
        }
        return true;
    }

    private static String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9-]", "").replaceFirst("^-*(.*?)-*$", "$1");
    }

    static {
        SIMPLE_FIELD_TYPES.add(String.class);
        SIMPLE_FIELD_TYPES.add(Double.class);
        SIMPLE_FIELD_TYPES.add(Float.class);
        SIMPLE_FIELD_TYPES.add(Long.class);
        SIMPLE_FIELD_TYPES.add(Integer.class);
        SIMPLE_FIELD_TYPES.add(Short.class);
        SIMPLE_FIELD_TYPES.add(Character.class);
        SIMPLE_FIELD_TYPES.add(Byte.class);
        SIMPLE_FIELD_TYPES.add(Double.TYPE);
        SIMPLE_FIELD_TYPES.add(Float.TYPE);
        SIMPLE_FIELD_TYPES.add(Long.TYPE);
        SIMPLE_FIELD_TYPES.add(Integer.TYPE);
        SIMPLE_FIELD_TYPES.add(Short.TYPE);
        SIMPLE_FIELD_TYPES.add(Character.TYPE);
        SIMPLE_FIELD_TYPES.add(Byte.TYPE);
    }
}

