/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class PodLogService {
    public static final String OPERATION_UNDEPLOY = "undeploy";
    public static final String OPERATION_STOP = "stop";
    private PodLogServiceContext context;
    private KitLogger log;
    private Watch podWatcher;
    private LogWatch logWatcher;
    private Map<String, Pod> addedPods = new ConcurrentHashMap<String, Pod>();
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private String watchingPodName;
    private CountDownLatch logWatchTerminateLatch;

    public PodLogService(PodLogServiceContext context) {
        this.context = context;
        this.log = context.getLog();
    }

    public void tailAppPodsLogs(final KubernetesClient kubernetes, final String namespace, final Set<HasMetadata> entities, boolean watchAddedPodsOnly, String onExitOperation, boolean followLog, Date ignorePodsOlderThan, boolean waitInCurrentThread) {
        LabelSelector selector = KubernetesHelper.extractPodLabelSelector(entities);
        if (selector != null) {
            String ctrlCMessage = "stop tailing the log";
            if (StringUtils.isNotBlank((CharSequence)onExitOperation)) {
                final String onExitOperationLower = onExitOperation.toLowerCase().trim();
                if (onExitOperationLower.equals(OPERATION_UNDEPLOY)) {
                    ctrlCMessage = "undeploy the app";
                } else if (onExitOperationLower.equals(OPERATION_STOP)) {
                    ctrlCMessage = "scale down the app and stop tailing the log";
                } else {
                    this.log.warn("Unknown on-exit command: `%s`", new Object[]{onExitOperationLower});
                }
                KubernetesClientUtil.resizeApp(kubernetes, namespace, entities, 1, this.log);
                Runtime.getRuntime().addShutdownHook(new Thread("pod log service shutdown hook"){

                    @Override
                    public void run() {
                        if (onExitOperationLower.equals(PodLogService.OPERATION_UNDEPLOY)) {
                            PodLogService.this.log.info("Undeploying the app:", new Object[0]);
                            KubernetesClientUtil.deleteEntities(kubernetes, namespace, entities, PodLogService.this.log);
                            if (PodLogService.this.context.getS2iBuildNameSuffix() != null) {
                                KubernetesClientUtil.deleteOpenShiftEntities(kubernetes, namespace, entities, PodLogService.this.context.getS2iBuildNameSuffix(), PodLogService.this.log);
                            }
                        } else if (onExitOperationLower.equals(PodLogService.OPERATION_STOP)) {
                            PodLogService.this.log.info("Stopping the app:", new Object[0]);
                            KubernetesClientUtil.resizeApp(kubernetes, namespace, entities, 0, PodLogService.this.log);
                        }
                        if (PodLogService.this.podWatcher != null) {
                            PodLogService.this.podWatcher.close();
                        }
                        PodLogService.this.closeLogWatcher();
                    }
                });
            }
            this.waitAndLogPods(kubernetes, namespace, selector, watchAddedPodsOnly, ctrlCMessage, followLog, ignorePodsOlderThan, waitInCurrentThread);
        } else {
            this.log.warn("No selector in deployment so cannot watch pods!", new Object[0]);
        }
    }

    private void waitAndLogPods(final KubernetesClient kubernetes, final String namespace, LabelSelector selector, boolean watchAddedPodsOnly, final String ctrlCMessage, final boolean followLog, Date ignorePodsOlderThan, boolean waitInCurrentThread) {
        List items;
        FilterWatchListDeletable pods = KubernetesHelper.withSelector((NonNamespaceOperation)((NonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), (LabelSelector)selector, (KitLogger)this.log);
        if (this.context.getPodName() != null) {
            this.log.info("Watching pod with selector %s, and name %s waiting for a running pod...", new Object[]{selector, this.context.getPodName()});
            pods = (FilterWatchListDeletable)pods.withField("metadata.name", this.context.getPodName());
        } else {
            this.log.info("Watching pods with selector %s waiting for a running pod...", new Object[]{selector});
        }
        Pod latestPod = null;
        boolean runningPod = false;
        PodList list = (PodList)pods.list();
        if (list != null && (items = list.getItems()) != null) {
            for (Pod pod : items) {
                if (!KubernetesHelper.isPodRunning((Pod)pod) && !KubernetesHelper.isPodWaiting((Pod)pod)) continue;
                if (latestPod == null || KubernetesHelper.isNewerResource((HasMetadata)pod, latestPod)) {
                    if (ignorePodsOlderThan != null) {
                        Date podCreateTime = KubernetesHelper.getCreationTimestamp((HasMetadata)pod);
                        if (podCreateTime != null && podCreateTime.compareTo(ignorePodsOlderThan) > 0) {
                            latestPod = pod;
                        }
                    } else {
                        latestPod = pod;
                    }
                }
                runningPod = true;
            }
        }
        if (latestPod != null) {
            this.onPod(Watcher.Action.ADDED, latestPod, kubernetes, namespace, ctrlCMessage, followLog);
        }
        if (!watchAddedPodsOnly && !runningPod) {
            this.log.warn("No pod is running yet. Are you sure you deployed your app using Eclipse JKube apply/deploy mechanism?", new Object[0]);
            this.log.warn("Or did you undeploy it? If so try running the Eclipse JKube apply/deploy tasks again.", new Object[0]);
        }
        this.podWatcher = pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                PodLogService.this.onPod(action, pod, kubernetes, namespace, ctrlCMessage, followLog);
            }

            public void onClose(WatcherException e) {
            }
        });
        if (waitInCurrentThread) {
            while (this.terminateLatch.getCount() > 0L) {
                try {
                    this.terminateLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void onPod(Watcher.Action action, Pod pod, KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog) {
        Pod watchPod;
        String newestPodName;
        KitLogger statusLog;
        String name = KubernetesHelper.getName((HasMetadata)pod);
        if (action.equals((Object)Watcher.Action.DELETED)) {
            this.addedPods.remove(name);
            if (Objects.equals(this.watchingPodName, name)) {
                this.watchingPodName = null;
                this.addedPods.remove(name);
            }
        } else if (action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED)) {
            this.addedPods.put(name, pod);
        }
        KitLogger kitLogger = statusLog = Objects.equals(name, newestPodName = KubernetesHelper.getName((HasMetadata)(watchPod = KubernetesHelper.getNewestPod(this.addedPods.values())))) ? this.context.getNewPodLog() : this.context.getOldPodLog();
        if (!action.equals((Object)Watcher.Action.MODIFIED) || this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            statusLog.info("%s status: %s%s", new Object[]{name, KubernetesClientUtil.getPodStatusDescription(pod), KubernetesClientUtil.getPodStatusMessagePostfix(action)});
        }
        if (watchPod != null && KubernetesHelper.isPodRunning((Pod)watchPod)) {
            this.watchLogOfPodName(kubernetes, namespace, ctrlCMessage, followLog, watchPod, KubernetesHelper.getName((HasMetadata)watchPod));
        }
    }

    private void watchLogOfPodName(KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog, Pod pod, String name) {
        if (this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            if (this.logWatcher != null) {
                this.log.info("Closing log watcher for %s as now watching %s", new Object[]{this.watchingPodName, name});
                this.closeLogWatcher();
            }
            PodResource podResource = (PodResource)((NonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).withName(name);
            List containers = KubernetesHelper.getContainers((Pod)pod);
            String containerName = null;
            if (followLog) {
                this.watchingPodName = name;
                this.logWatchTerminateLatch = new CountDownLatch(1);
                if (containers.size() < 2) {
                    this.logWatcher = (LogWatch)podResource.watchLog();
                } else {
                    containerName = this.getLogContainerName(containers);
                    this.logWatcher = (LogWatch)((ContainerResource)podResource.inContainer((Object)containerName)).watchLog();
                }
                this.watchLog(this.logWatcher, name, "Failed to read log of pod " + name + ".", ctrlCMessage, containerName);
            } else {
                String logText;
                if (containers.size() < 2) {
                    logText = podResource.getLog();
                } else {
                    containerName = this.getLogContainerName(containers);
                    logText = ((ContainerResource)podResource.inContainer((Object)containerName)).getLog();
                }
                if (logText != null) {
                    String[] lines = logText.split("\n");
                    this.log.info("Log of pod: %s%s", new Object[]{name, this.containerNameMessage(containerName)});
                    this.log.info("", new Object[0]);
                    for (String line : lines) {
                        this.log.info("[[s]]%s", new Object[]{line});
                    }
                }
                this.terminateLatch.countDown();
            }
        }
    }

    private String getLogContainerName(List<Container> containers) {
        if (StringUtils.isNotBlank((CharSequence)this.context.getLogContainerName())) {
            for (Container container : containers) {
                if (!Objects.equals(this.context.getLogContainerName(), container.getName())) continue;
                return this.context.getLogContainerName();
            }
            this.log.error("log container name %s does not exist in pod!! Did you set the correct value for property 'jkube.log.container'", new Object[]{this.context.getLogContainerName()});
        }
        return containers.get(0).getName();
    }

    private void closeLogWatcher() {
        if (this.logWatcher != null) {
            this.logWatcher.close();
            this.logWatcher = null;
        }
        if (this.logWatchTerminateLatch != null) {
            this.logWatchTerminateLatch.countDown();
        }
    }

    private void watchLog(LogWatch logWatcher, String podName, String failureMessage, String ctrlCMessage, String containerName) {
        this.context.getNewPodLog().info("Tailing log of pod: " + podName + this.containerNameMessage(containerName), new Object[0]);
        this.context.getNewPodLog().info("Press Ctrl-C to " + ctrlCMessage, new Object[0]);
        this.context.getNewPodLog().info("", new Object[0]);
        KubernetesHelper.printLogsAsync((LogWatch)logWatcher, (String)failureMessage, (CountDownLatch)this.logWatchTerminateLatch, (KitLogger)this.log);
    }

    private String containerNameMessage(String containerName) {
        if (StringUtils.isNotBlank((CharSequence)containerName)) {
            return " container: " + containerName;
        }
        return "";
    }

    public static class PodLogServiceContext {
        private static final String DEFAULT_S2I_BUILD_NAME_SUFFIX = "-s2i";
        private KitLogger log;
        private KitLogger newPodLog;
        private KitLogger oldPodLog;
        private String logContainerName;
        private String podName;
        private String s2iBuildNameSuffix;

        public String getS2iBuildNameSuffix() {
            return Optional.ofNullable(this.s2iBuildNameSuffix).orElse(DEFAULT_S2I_BUILD_NAME_SUFFIX);
        }

        public static PodLogServiceContextBuilder builder() {
            return new PodLogServiceContextBuilder();
        }

        public PodLogServiceContextBuilder toBuilder() {
            return new PodLogServiceContextBuilder().log(this.log).newPodLog(this.newPodLog).oldPodLog(this.oldPodLog).logContainerName(this.logContainerName).podName(this.podName).s2iBuildNameSuffix(this.s2iBuildNameSuffix);
        }

        public PodLogServiceContext(KitLogger log, KitLogger newPodLog, KitLogger oldPodLog, String logContainerName, String podName, String s2iBuildNameSuffix) {
            this.log = log;
            this.newPodLog = newPodLog;
            this.oldPodLog = oldPodLog;
            this.logContainerName = logContainerName;
            this.podName = podName;
            this.s2iBuildNameSuffix = s2iBuildNameSuffix;
        }

        public PodLogServiceContext() {
        }

        public KitLogger getLog() {
            return this.log;
        }

        public KitLogger getNewPodLog() {
            return this.newPodLog;
        }

        public KitLogger getOldPodLog() {
            return this.oldPodLog;
        }

        public String getLogContainerName() {
            return this.logContainerName;
        }

        public String getPodName() {
            return this.podName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PodLogServiceContext)) {
                return false;
            }
            PodLogServiceContext other = (PodLogServiceContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KitLogger this$log = this.getLog();
            KitLogger other$log = other.getLog();
            if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
                return false;
            }
            KitLogger this$newPodLog = this.getNewPodLog();
            KitLogger other$newPodLog = other.getNewPodLog();
            if (this$newPodLog == null ? other$newPodLog != null : !this$newPodLog.equals(other$newPodLog)) {
                return false;
            }
            KitLogger this$oldPodLog = this.getOldPodLog();
            KitLogger other$oldPodLog = other.getOldPodLog();
            if (this$oldPodLog == null ? other$oldPodLog != null : !this$oldPodLog.equals(other$oldPodLog)) {
                return false;
            }
            String this$logContainerName = this.getLogContainerName();
            String other$logContainerName = other.getLogContainerName();
            if (this$logContainerName == null ? other$logContainerName != null : !this$logContainerName.equals(other$logContainerName)) {
                return false;
            }
            String this$podName = this.getPodName();
            String other$podName = other.getPodName();
            if (this$podName == null ? other$podName != null : !this$podName.equals(other$podName)) {
                return false;
            }
            String this$s2iBuildNameSuffix = this.getS2iBuildNameSuffix();
            String other$s2iBuildNameSuffix = other.getS2iBuildNameSuffix();
            return !(this$s2iBuildNameSuffix == null ? other$s2iBuildNameSuffix != null : !this$s2iBuildNameSuffix.equals(other$s2iBuildNameSuffix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PodLogServiceContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KitLogger $log = this.getLog();
            result = result * 59 + ($log == null ? 43 : $log.hashCode());
            KitLogger $newPodLog = this.getNewPodLog();
            result = result * 59 + ($newPodLog == null ? 43 : $newPodLog.hashCode());
            KitLogger $oldPodLog = this.getOldPodLog();
            result = result * 59 + ($oldPodLog == null ? 43 : $oldPodLog.hashCode());
            String $logContainerName = this.getLogContainerName();
            result = result * 59 + ($logContainerName == null ? 43 : $logContainerName.hashCode());
            String $podName = this.getPodName();
            result = result * 59 + ($podName == null ? 43 : $podName.hashCode());
            String $s2iBuildNameSuffix = this.getS2iBuildNameSuffix();
            result = result * 59 + ($s2iBuildNameSuffix == null ? 43 : $s2iBuildNameSuffix.hashCode());
            return result;
        }

        public static class PodLogServiceContextBuilder {
            private KitLogger log;
            private KitLogger newPodLog;
            private KitLogger oldPodLog;
            private String logContainerName;
            private String podName;
            private String s2iBuildNameSuffix;

            PodLogServiceContextBuilder() {
            }

            public PodLogServiceContextBuilder log(KitLogger log) {
                this.log = log;
                return this;
            }

            public PodLogServiceContextBuilder newPodLog(KitLogger newPodLog) {
                this.newPodLog = newPodLog;
                return this;
            }

            public PodLogServiceContextBuilder oldPodLog(KitLogger oldPodLog) {
                this.oldPodLog = oldPodLog;
                return this;
            }

            public PodLogServiceContextBuilder logContainerName(String logContainerName) {
                this.logContainerName = logContainerName;
                return this;
            }

            public PodLogServiceContextBuilder podName(String podName) {
                this.podName = podName;
                return this;
            }

            public PodLogServiceContextBuilder s2iBuildNameSuffix(String s2iBuildNameSuffix) {
                this.s2iBuildNameSuffix = s2iBuildNameSuffix;
                return this;
            }

            public PodLogServiceContext build() {
                return new PodLogServiceContext(this.log, this.newPodLog, this.oldPodLog, this.logContainerName, this.podName, this.s2iBuildNameSuffix);
            }

            public String toString() {
                return "PodLogService.PodLogServiceContext.PodLogServiceContextBuilder(log=" + this.log + ", newPodLog=" + this.newPodLog + ", oldPodLog=" + this.oldPodLog + ", logContainerName=" + this.logContainerName + ", podName=" + this.podName + ", s2iBuildNameSuffix=" + this.s2iBuildNameSuffix + ")";
            }
        }
    }
}

