/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.api.model.batch.DoneableJob;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableImageStream;
import io.fabric8.openshift.api.model.DoneableRoute;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.UserConfigurationCompare;

public class PatchService {
    private final KubernetesClient kubernetesClient;
    private final KitLogger log;
    private static Map<String, EntityPatcher<? extends HasMetadata>> patchers = new HashMap<String, EntityPatcher<? extends HasMetadata>>();

    public PatchService(KubernetesClient client, KitLogger log) {
        this.kubernetesClient = client;
        this.log = log;
    }

    public <T extends HasMetadata> T compareAndPatchEntity(String namespace, T newDto, T oldDto) {
        EntityPatcher<? extends HasMetadata> dispatcher = patchers.get(newDto.getKind());
        if (dispatcher == null) {
            throw new IllegalArgumentException("Internal: No patcher for " + newDto.getKind() + " found");
        }
        newDto.getMetadata().setResourceVersion(oldDto.getMetadata().getResourceVersion());
        return (T)dispatcher.patch(this.kubernetesClient, namespace, newDto, oldDto);
    }

    private static EntityPatcher<Pod> podPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneablePod entity = (DoneablePod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<ReplicationController> rcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneableReplicationController entity = (DoneableReplicationController)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<Service> servicePatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneableService entity = (DoneableService)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(newObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<Secret> secretPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneableSecret entity = (DoneableSecret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getData(), (Object)oldObj.getData())) {
                entity.withData(newObj.getData());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getStringData(), (Object)oldObj.getStringData())) {
                entity.withStringData(newObj.getStringData());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<PersistentVolumeClaim> pvcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneablePersistentVolumeClaim entity = (DoneablePersistentVolumeClaim)((Resource)((NonNamespaceOperation)client.persistentVolumeClaims().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<CustomResourceDefinition> crdPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneableCustomResourceDefinition entity = (DoneableCustomResourceDefinition)((Resource)client.customResourceDefinitions().withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<Job> jobPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            DoneableJob entity = (DoneableJob)((ScalableResource)client.batch().jobs().withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec().getSelector(), (Object)oldObj.getSpec().getSelector())) {
                entity.editSpec().withSelector(newObj.getSpec().getSelector());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec().getTemplate(), (Object)oldObj.getSpec().getSelector())) {
                entity.editSpec().withTemplate(newObj.getSpec().getTemplate());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<BuildConfig> bcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("BuildConfig can only be patched when connected to an OpenShift cluster");
            }
            DoneableBuildConfig entity = (DoneableBuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<ImageStream> isPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("ImageStream can only be patched when connected to an OpenShift cluster");
            }
            DoneableImageStream entity = (DoneableImageStream)((Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    private static EntityPatcher<Route> routePatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("Route can only be patched when connected to an OpenShift cluster");
            }
            DoneableRoute entity = (DoneableRoute)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit();
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return entity.done();
        };
    }

    static {
        patchers.put("Pod", PatchService.podPatcher());
        patchers.put("ReplicationController", PatchService.rcPatcher());
        patchers.put("Service", PatchService.servicePatcher());
        patchers.put("BuildConfig", PatchService.bcPatcher());
        patchers.put("ImageStream", PatchService.isPatcher());
        patchers.put("Secret", PatchService.secretPatcher());
        patchers.put("PersistentVolumeClaim", PatchService.pvcPatcher());
        patchers.put("CustomResourceDefinition", PatchService.crdPatcher());
        patchers.put("Job", PatchService.jobPatcher());
        patchers.put("Route", PatchService.routePatcher());
    }

    static interface EntityPatcher<T extends HasMetadata> {
        public T patch(KubernetesClient var1, String var2, T var3, T var4);
    }
}

