/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;

public class RegistryConfig
implements Serializable {
    private static final long serialVersionUID = -7864593044203613241L;
    private String registry;
    private List<RegistryServerConfiguration> settings;
    private boolean skipExtendedAuth;
    private Map authConfig;
    private transient UnaryOperator<String> passwordDecryptionMethod;

    public static RegistryConfigBuilder builder() {
        return new RegistryConfigBuilder();
    }

    public RegistryConfig(String registry, List<RegistryServerConfiguration> settings, boolean skipExtendedAuth, Map authConfig, UnaryOperator<String> passwordDecryptionMethod) {
        this.registry = registry;
        this.settings = settings;
        this.skipExtendedAuth = skipExtendedAuth;
        this.authConfig = authConfig;
        this.passwordDecryptionMethod = passwordDecryptionMethod;
    }

    public RegistryConfig() {
    }

    public String getRegistry() {
        return this.registry;
    }

    public List<RegistryServerConfiguration> getSettings() {
        return this.settings;
    }

    public boolean isSkipExtendedAuth() {
        return this.skipExtendedAuth;
    }

    public Map getAuthConfig() {
        return this.authConfig;
    }

    public UnaryOperator<String> getPasswordDecryptionMethod() {
        return this.passwordDecryptionMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryConfig)) {
            return false;
        }
        RegistryConfig other = (RegistryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        List<RegistryServerConfiguration> this$settings = this.getSettings();
        List<RegistryServerConfiguration> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        if (this.isSkipExtendedAuth() != other.isSkipExtendedAuth()) {
            return false;
        }
        Map this$authConfig = this.getAuthConfig();
        Map other$authConfig = other.getAuthConfig();
        return !(this$authConfig == null ? other$authConfig != null : !((Object)this$authConfig).equals(other$authConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        List<RegistryServerConfiguration> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        result = result * 59 + (this.isSkipExtendedAuth() ? 79 : 97);
        Map $authConfig = this.getAuthConfig();
        result = result * 59 + ($authConfig == null ? 43 : ((Object)$authConfig).hashCode());
        return result;
    }

    public static class RegistryConfigBuilder {
        private String registry;
        private List<RegistryServerConfiguration> settings;
        private boolean skipExtendedAuth;
        private Map authConfig;
        private UnaryOperator<String> passwordDecryptionMethod;

        RegistryConfigBuilder() {
        }

        public RegistryConfigBuilder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public RegistryConfigBuilder settings(List<RegistryServerConfiguration> settings) {
            this.settings = settings;
            return this;
        }

        public RegistryConfigBuilder skipExtendedAuth(boolean skipExtendedAuth) {
            this.skipExtendedAuth = skipExtendedAuth;
            return this;
        }

        public RegistryConfigBuilder authConfig(Map authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public RegistryConfigBuilder passwordDecryptionMethod(UnaryOperator<String> passwordDecryptionMethod) {
            this.passwordDecryptionMethod = passwordDecryptionMethod;
            return this;
        }

        public RegistryConfig build() {
            return new RegistryConfig(this.registry, this.settings, this.skipExtendedAuth, this.authConfig, this.passwordDecryptionMethod);
        }

        public String toString() {
            return "RegistryConfig.RegistryConfigBuilder(registry=" + this.registry + ", settings=" + this.settings + ", skipExtendedAuth=" + this.skipExtendedAuth + ", authConfig=" + this.authConfig + ", passwordDecryptionMethod=" + this.passwordDecryptionMethod + ")";
        }
    }
}

